/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"givespawner"}, description="Gives a player a mob spawner of the specified type.", usage="/givespawner <player> <mobType> [amount]", permission="essentialz.givespawner")
public class GiveSpawnerCommand
extends EszCommand {
    public GiveSpawnerCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        EntityType entityType = args.getEnum(1, EntityType.class);
        int amount = args.getInt(2, 1);
        if (args.size() < 2) {
            throw new CommandUsageException("/<command> <player> <mobType> [amount]");
        }
        if (entityType == null || !entityType.isSpawnable() || !entityType.isAlive()) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "invalidMobType", "{ac}You have to specify a valid mob type.", new MessageManager.Replaceable[0]));
            return false;
        }
        ItemStack spawnerItem = new ItemStack(Material.SPAWNER, amount);
        BlockStateMeta meta = (BlockStateMeta)spawnerItem.getItemMeta();
        CreatureSpawner state = (CreatureSpawner)meta.getBlockState();
        state.setSpawnedType(entityType);
        meta.setBlockState((BlockState)state);
        spawnerItem.setItemMeta((ItemMeta)meta);
        targetPlayer.getInventory().addItem(new ItemStack[]{spawnerItem});
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ITEMS, "givespawnerSuccess", "&7Gave {ac}{amount} {mobType} &7spawner(s) to {ac}{player}&7.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{amount}", String.valueOf(amount)), new MessageManager.Replaceable<String>("{mobType}", entityType.name())));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return new ArrayList<EntityType>(List.of(EntityType.values())).stream().filter(EntityType::isSpawnable).filter(EntityType::isAlive).map(Enum::name).map(String::toLowerCase).filter(et -> et.startsWith(args.getCurrentArg().toLowerCase())).toList();
        }
        if (args.getCurrentArgIndex() == 2) {
            return this.getDisplayOptions(List.of("1", "16", "32", "64"), args.getCurrentArg());
        }
        return List.of();
    }
}

