/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.economy;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.EconomyUtil;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"pay"}, description="Pay another player money", usage="/pay <player> <amount>", permission="essentialz.pay")
public class PayCommand
extends EszCommand {
    @InjectManager
    private EconomyManager economyManager;
    @InjectManager
    private MessageManager messageManager;
    @InjectManager
    private ConfigService configService;

    public PayCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String s, ArgumentList args) throws CommandException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        String stringAamount = args.getArg(1);
        double amount = EconomyUtil.parseNumber(stringAamount, new EconomyConfig(this.configService.getConfig(EszConfig.ECONOMY)));
        double senderBalance = this.economyManager.getBalance((OfflinePlayer)player);
        if (senderBalance < 0.0) {
            throw new RuntimeException("Sender balance is negative!");
        }
        if (senderBalance < amount) {
            sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "insufficientFunds", "{ac}You do not have enough funds!", new MessageManager.Replaceable[0]));
            return false;
        }
        this.economyManager.withdraw((OfflinePlayer)player, amount);
        this.economyManager.deposit((OfflinePlayer)targetPlayer, amount);
        sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ECONOMY, "paySender", "&7You have paid {ac}{player} {amount}&7.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{amount}", this.economyManager.format(amount))));
        targetPlayer.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ECONOMY, "payReceiver", "&7You have received {ac}{amount} &7from {ac}{player}.", new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{amount}", this.economyManager.format(amount))));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return this.getDisplayOptions(List.of("<amount>"), args.getCurrentArg());
        }
        return List.of();
    }
}

