/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.communication;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"teamchattoggle"}, description="Toggle team chat on or off.", usage="/teamchattoggle", aliases={"tctoggle", "toggleteamchat"}, permission="essentialz.teamchat")
public class ToggleTeamchatCommand
extends EszCommand {
    @InjectManager
    private Storage storage;

    public ToggleTeamchatCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        PlayerData playerData = this.storage.load(player.getUniqueId());
        boolean newStatus = !playerData.isEnableTeamchat();
        playerData.setEnableTeamchat(newStatus);
        this.storage.save(playerData);
        String statusMsgKey = newStatus ? "tcEnabled" : "tcDisabled";
        String statusMsgDefault = newStatus ? "&7You have {ac}enabled &7the team chat." : "&7You have {ac}disabled &7the team chat.";
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.SUCCESS, statusMsgKey, statusMsgDefault, new MessageManager.Replaceable[0]));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        return List.of();
    }
}

