/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.communication;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.LastMsgManager;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"msg"}, description="Send a private message to another player.", usage="/msg <player> <message>", aliases={"message", "tell", "whisper", "pm", "dm"}, permission="essentialz.msg")
public class MsgCommand
extends EszCommand {
    @InjectManager
    private Storage storage;
    @InjectManager
    private LastMsgManager lastMsgManager;

    public MsgCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        PlayerData targetPlayerData;
        Player senderPlayer;
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        String message = args.getJoinedString(1);
        if (message.isEmpty()) {
            throw new CommandUsageException("/" + command.getName() + " <message>");
        }
        if (targetPlayer == null) {
            throw new CommandUsageException("/" + command.getName() + " <player> <message>");
        }
        if (sender instanceof Player && (senderPlayer = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId())) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "cannotMessageYourself", "{ac}You cannot send a private message to yourself.", new MessageManager.Replaceable[0]));
            return false;
        }
        if (sender instanceof Player) {
            senderPlayer = (Player)sender;
            PlayerData senderPlayerData = this.storage.load(senderPlayer.getUniqueId());
            if (!senderPlayerData.isEnableDms()) {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "yourDmsDisabled", "{ac}You have disabled private messages. Enable them using /msgtoggle to send messages.", new MessageManager.Replaceable[0]));
                return false;
            }
            boolean isIgnoring = this.storage.isPlayerIgnoring(targetPlayer.getUniqueId(), senderPlayer.getUniqueId());
            if (isIgnoring) {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "playerIsIgnoringYou", "{ac}{player} is ignoring you. Your message was not sent.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
                return false;
            }
            boolean youAreIgnoring = this.storage.isPlayerIgnoring(senderPlayer.getUniqueId(), targetPlayer.getUniqueId());
            if (youAreIgnoring) {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "youAreIgnoringPlayer", "{ac}You are ignoring {player}. Unignore them to send messages.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
                return false;
            }
        }
        if (!(targetPlayerData = this.storage.load(targetPlayer.getUniqueId())).isEnableDms()) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "playerDmsDisabled", "{ac}{player} has disabled private messages.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
            return false;
        }
        boolean allowToUseColor = sender.hasPermission("essentialz.msg.color");
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.COMMUNICATION, "privateMessageSent", "&7&8[&7To &r{ac}{recipient}&7&8]&7: {message}", new MessageManager.Replaceable<String>("{recipient}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{message}", message, allowToUseColor)));
        targetPlayer.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.COMMUNICATION, "privateMessageReceived", "&7&8[&7From &r{ac}{sender}&7&8]&7: {message}", new MessageManager.Replaceable<String>("{sender}", sender.getName()), new MessageManager.Replaceable<String>("{message}", message, allowToUseColor)));
        if (sender instanceof Player) {
            Player senderPlayer2 = (Player)sender;
            this.lastMsgManager.setLastMsg(senderPlayer2.getUniqueId(), targetPlayer.getUniqueId());
            this.lastMsgManager.setLastMsg(targetPlayer.getUniqueId(), senderPlayer2.getUniqueId());
        }
        return false;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

