/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz;

import com.zetaplugins.essentialz.features.economy.VaultEconomyImplProvider;
import com.zetaplugins.essentialz.features.economy.manager.BuiltinEconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.UnusedEconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.VaultEconomyManager;
import com.zetaplugins.essentialz.storage.MySQLStorage;
import com.zetaplugins.essentialz.storage.SQLiteStorage;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.services.bStats.Metrics;
import com.zetaplugins.zetacore.services.commands.AutoCommandRegistrar;
import com.zetaplugins.zetacore.services.config.ConfigService;
import com.zetaplugins.zetacore.services.di.ManagerRegistry;
import com.zetaplugins.zetacore.services.events.AutoEventRegistrar;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class EssentialZ
extends JavaPlugin {
    private static final String PACKAGE_PREFIX = "com.zetaplugins.essentialz";
    private static final List<String> ECONOMY_COMMANDS = List.of("balance", "pay", "baltop");
    private ConfigService configManager;
    private ManagerRegistry managerRegistry;
    private final boolean hasPlaceholderApi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private final boolean hasVault = Bukkit.getPluginManager().getPlugin("Vault") != null;

    public void onEnable() {
        Permission.registerAll();
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.configManager = new ConfigService(this);
        this.managerRegistry = new ManagerRegistry(this);
        this.managerRegistry.registerInstance(this.configManager);
        this.managerRegistry.registerInstance(Storage.class, this.createPlayerDataStorage());
        this.managerRegistry.registerInstance(new LanguageManager(this));
        this.managerRegistry.registerInstance(new MessageManager(this));
        this.initEconomy();
        this.registerCommands();
        this.registerListeners();
        this.initBstats();
        this.getLogger().info("EssentialZ enabled!");
    }

    public void onDisable() {
        this.getLogger().info("EssentialZ disabled!");
    }

    private void initEconomy() {
        boolean economyEnabled = this.configManager.getConfig(EszConfig.ECONOMY).getBoolean("enabled", true);
        if (this.hasVault && economyEnabled) {
            this.getLogger().info("Vault detected, enabling Vault economy support.");
            VaultEconomyImplProvider.register(this, this.managerRegistry);
            this.managerRegistry.registerInstance(EconomyManager.class, new VaultEconomyManager());
        } else if (economyEnabled) {
            this.getLogger().warning("Vault not detected, using built-in economy manager.");
            this.managerRegistry.registerInstance(EconomyManager.class, new BuiltinEconomyManager());
        } else {
            this.getLogger().info("Economy system disabled.");
            this.managerRegistry.registerInstance(EconomyManager.class, new UnusedEconomyManager());
        }
    }

    private Storage createPlayerDataStorage() {
        return switch (this.configManager.getConfig(EszConfig.STORAGE).getString("type").toLowerCase()) {
            case "mysql" -> {
                this.getLogger().info("Using MySQL storage");
                yield new MySQLStorage(this);
            }
            case "sqlite" -> {
                this.getLogger().info("Using SQLite storage");
                yield new SQLiteStorage(this);
            }
            default -> {
                this.getLogger().warning("Invalid storage type in config.yml! Using SQLite storage as fallback.");
                yield new SQLiteStorage(this);
            }
        };
    }

    private void registerCommands() {
        List<String> registeredCommands = new AutoCommandRegistrar.Builder().setPlugin(this).setPackagePrefix(PACKAGE_PREFIX).setManagerRegistry(this.managerRegistry).build().registerAllCommands(this::shouldRegisterCommand);
        FileConfiguration config = this.configManager.getConfig(EszConfig.COMMANDS);
        registeredCommands.sort(String::compareTo);
        for (String command : registeredCommands) {
            if (config.contains(command)) continue;
            config.set(command, (Object)true);
        }
        this.configManager.saveConfig(EszConfig.COMMANDS, config);
        this.getLogger().info("Registered " + registeredCommands.size() + " commands.");
    }

    private void registerListeners() {
        List<String> registeredEventListeners = new AutoEventRegistrar.Builder().setPlugin(this).setPackagePrefix(PACKAGE_PREFIX).setManagerRegistry(this.managerRegistry).build().registerAllListeners();
        this.getLogger().info("Registered " + registeredEventListeners.size() + " event listeners.");
    }

    private boolean shouldRegisterCommand(String commandName) {
        boolean economyEnabled = this.configManager.getConfig(EszConfig.ECONOMY).getBoolean("enabled", true);
        if (ECONOMY_COMMANDS.contains(commandName) && !economyEnabled) {
            return false;
        }
        return this.configManager.getConfig(EszConfig.COMMANDS).getBoolean(commandName, true);
    }

    private void initBstats() {
        int pluginId = 28159;
        Metrics metrics = new Metrics(this, 28159);
        metrics.addCustomChart(new Metrics.SimplePie("storage_type", () -> this.configManager.getConfig(EszConfig.STORAGE).getString("type")));
        metrics.addCustomChart(new Metrics.SimplePie("language", () -> this.getConfig().getString("lang")));
        metrics.addCustomChart(new Metrics.SimplePie("economy_system", () -> {
            EconomyManager economyManager = this.managerRegistry.getOrCreate(EconomyManager.class);
            if (economyManager instanceof VaultEconomyManager) {
                return "vault";
            }
            if (economyManager instanceof BuiltinEconomyManager) {
                return "builtin";
            }
            return "disabled";
        }));
        metrics.addCustomChart(new Metrics.SimplePie("chat_enabled", () -> {
            boolean chatEnabled = this.configManager.getConfig(EszConfig.CHAT).getBoolean("enableCustomChat", true);
            return chatEnabled ? "true" : "false";
        }));
        this.getLogger().info("bStats metrics initialized.");
    }
}

