/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.essentialz.storage.model.WarpData;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public abstract class SQLStorage
extends Storage {
    private static final String CSV_SEPARATOR = ",";

    public SQLStorage(EssentialZ plugin) {
        super(plugin);
    }

    public abstract ConnectionPool getConnectionPool();

    public Connection getConnection() throws SQLException {
        return this.getConnectionPool().getConnection();
    }

    @Override
    public void initializeDatabase() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                StringBuilder playerTableSql = new StringBuilder();
                playerTableSql.append("CREATE TABLE IF NOT EXISTS players (").append("uuid CHAR(36) PRIMARY KEY, ").append("enableTeamchat BOOLEAN DEFAULT TRUE, ").append("enableDms BOOLEAN DEFAULT TRUE, ").append("balance DOUBLE DEFAULT 0.0").append(");");
                statement.executeUpdate(playerTableSql.toString());
                StringBuilder ignoreTableSql = new StringBuilder();
                ignoreTableSql.append("CREATE TABLE IF NOT EXISTS ignores (").append("playerUuid CHAR(36), ").append("targetUuid CHAR(36), ").append("PRIMARY KEY (playerUuid, targetUuid), ").append("FOREIGN KEY (playerUuid) REFERENCES players(uuid) ON DELETE CASCADE, ").append("FOREIGN KEY (targetUuid) REFERENCES players(uuid) ON DELETE CASCADE").append(");");
                statement.executeUpdate(ignoreTableSql.toString());
                StringBuilder warpsTableSql = new StringBuilder();
                warpsTableSql.append("CREATE TABLE IF NOT EXISTS warps (").append("name TEXT PRIMARY KEY, ").append("world TEXT, ").append("x DOUBLE, ").append("y DOUBLE, ").append("z DOUBLE, ").append("yaw FLOAT, ").append("pitch FLOAT").append(");");
                statement.executeUpdate(warpsTableSql.toString());
                this.migrateDatabase();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to initialize SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to initialize SQL database:", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public PlayerData load(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PlayerData mapResultSetToPlayerData(ResultSet resultSet, UUID uuid) throws SQLException {
        PlayerData playerData = new PlayerData(uuid);
        playerData.setEnableTeamchat(resultSet.getBoolean("enableTeamchat"));
        playerData.setEnableDms(resultSet.getBoolean("enableDms"));
        playerData.setBalance(resultSet.getDouble("balance"));
        playerData.clearModifiedFields();
        return playerData;
    }

    @Override
    public void save(PlayerData playerData) {
        if (!playerData.hasChanges()) {
            return;
        }
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            boolean exists = this.checkIfEntryExists(connection, playerData.getUuid());
            if (exists) {
                this.updatePlayerData(connection, playerData);
            } else {
                this.insertPlayerData(connection, playerData);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save player data:", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfEntryExists(Connection connection, String uuid) {
        String selectQuery = "SELECT 1 FROM players WHERE uuid = ?";
        try (PreparedStatement selectStmt = connection.prepareStatement("SELECT 1 FROM players WHERE uuid = ?");){
            boolean bl;
            block14: {
                selectStmt.setString(1, uuid);
                ResultSet resultSet = selectStmt.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to check if player entry exists:", e);
            return false;
        }
    }

    private boolean insertPlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block8: {
            String insertQuery = "INSERT INTO players (uuid, enableTeamchat, enableDms, balance) VALUES (?, ?, ?, ?)";
            PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO players (uuid, enableTeamchat, enableDms, balance) VALUES (?, ?, ?, ?)");
            try {
                insertStmt.setString(1, playerData.getUuid());
                insertStmt.setBoolean(2, playerData.isEnableTeamchat());
                insertStmt.setBoolean(3, playerData.isEnableDms());
                insertStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (insertStmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (insertStmt != null) {
                        try {
                            insertStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to insert player data:", e);
                    return false;
                }
            }
            insertStmt.close();
        }
        return bl;
    }

    private boolean updatePlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block20: {
            StringBuilder updateQuery = new StringBuilder("UPDATE players SET ");
            ArrayList<Object> params = new ArrayList<Object>();
            for (String field : playerData.getModifiedFields()) {
                updateQuery.append(field).append(" = ?, ");
                switch (field) {
                    case "enableTeamchat": {
                        params.add(playerData.isEnableTeamchat());
                        break;
                    }
                    case "enableDms": {
                        params.add(playerData.isEnableDms());
                        break;
                    }
                    case "balance": {
                        params.add(playerData.getBalance());
                    }
                }
            }
            updateQuery.setLength(updateQuery.length() - 2);
            updateQuery.append(" WHERE uuid = ?");
            params.add(playerData.getUuid());
            PreparedStatement updateStmt = connection.prepareStatement(updateQuery.toString());
            try {
                for (int i = 0; i < params.size(); ++i) {
                    updateStmt.setObject(i + 1, params.get(i));
                }
                updateStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (updateStmt == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (updateStmt != null) {
                        try {
                            updateStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to update player data:", e);
                    return false;
                }
            }
            updateStmt.close();
        }
        return bl;
    }

    @Override
    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    protected abstract String getInserOrReplacePlayerStatement();

    @Override
    public void clearDatabase() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                statement.executeUpdate("DELETE FROM players;");
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to clear SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to clear SQL database:", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean togglePlayerIgnore(UUID playerUuid, UUID targetUuid) {
        String checkQuery = "SELECT 1 FROM ignores WHERE playerUuid = ? AND targetUuid = ?";
        String insertQuery = "INSERT INTO ignores (playerUuid, targetUuid) VALUES (?, ?)";
        String deleteQuery = "DELETE FROM ignores WHERE playerUuid = ? AND targetUuid = ?";
        try {
            boolean bl;
            Connection connection = this.getConnection();
            if (connection == null) {
                boolean bl2 = false;
                return bl2;
            }
            PreparedStatement checkStmt = connection.prepareStatement("SELECT 1 FROM ignores WHERE playerUuid = ? AND targetUuid = ?");
            checkStmt.setString(1, playerUuid.toString());
            checkStmt.setString(2, targetUuid.toString());
            ResultSet resultSet = checkStmt.executeQuery();
            if (resultSet.next()) {
                try (PreparedStatement deleteStmt = connection.prepareStatement("DELETE FROM ignores WHERE playerUuid = ? AND targetUuid = ?");){
                    deleteStmt.setString(1, playerUuid.toString());
                    deleteStmt.setString(2, targetUuid.toString());
                    deleteStmt.executeUpdate();
                    boolean bl3 = false;
                    return bl3;
                }
            }
            try (PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO ignores (playerUuid, targetUuid) VALUES (?, ?)");){
                insertStmt.setString(1, playerUuid.toString());
                insertStmt.setString(2, targetUuid.toString());
                insertStmt.executeUpdate();
                bl = true;
                if (insertStmt == null) return bl;
            }
            return bl;
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                if (checkStmt != null) {
                    checkStmt.close();
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to toggle player ignore status:", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isPlayerIgnoring(UUID playerUuid, UUID targetUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected abstract String getInserOrReplaceWarpStatement();

    /*
     * Exception decompiling
     */
    @Override
    public WarpData getWarp(String warpName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void saveWarp(WarpData warpData) {
        String sql = this.getInserOrReplaceWarpStatement();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, warpData.getName());
                statement.setString(2, warpData.getWorld());
                statement.setDouble(3, warpData.getX());
                statement.setDouble(4, warpData.getY());
                statement.setDouble(5, warpData.getZ());
                statement.setFloat(6, warpData.getYaw());
                statement.setFloat(7, warpData.getPitch());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save warp to SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save warp to SQL database:", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteWarp(String warpName) {
        String sql = "DELETE FROM warps WHERE name = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block18: {
                if (connection == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                PreparedStatement statement = connection.prepareStatement("DELETE FROM warps WHERE name = ?");
                try {
                    statement.setString(1, warpName);
                    int rowsAffected = statement.executeUpdate();
                    boolean bl2 = bl = rowsAffected > 0;
                    if (statement == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete warp from SQL database:", e);
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete warp from SQL database:", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getAllWarpNames() {
        ArrayList<String> warpNames = new ArrayList<String>();
        String sql = "SELECT name FROM warps";
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<String> arrayList = warpNames;
                return arrayList;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT name FROM warps");){
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        warpNames.add(resultSet.getString("name"));
                    }
                    return warpNames;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
                    return warpNames;
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
                return warpNames;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
        }
        return warpNames;
    }
}

