/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.listeners;

import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterListener;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.services.config.ConfigService;
import io.papermc.paper.event.player.AsyncChatEvent;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.permissions.Permissible;

@AutoRegisterListener
public class CustomChatListener
implements Listener {
    @InjectManager
    private ConfigService configManager;
    @InjectManager
    private MessageManager messageManager;

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        if (!this.configManager.getConfig(EszConfig.CHAT).getBoolean("enableCustomChat", true)) {
            return;
        }
        event.setCancelled(true);
        Player player = event.getPlayer();
        if (!Permission.CHAT.has((Permissible)event.getPlayer())) {
            player.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "notAllowedToChat", "{ac}You are not allowed to chat.", new MessageManager.Replaceable[0]));
            return;
        }
        boolean allowColors = Permission.CHAT_COLOR.has((Permissible)event.getPlayer());
        String rawText = PlainTextComponentSerializer.plainText().serialize(event.message());
        String format = this.configManager.getConfig(EszConfig.CHAT).getString("chatFormat", "&7{player_displayname} &8\u00bb &f{message}");
        String rawDisplayName = PlainTextComponentSerializer.plainText().serialize(player.displayName());
        for (Player onlinePlayer : Bukkit.getOnlinePlayers()) {
            onlinePlayer.sendMessage(this.messageManager.formatMsg(format, new MessageManager.Replaceable<String>("{player_displayname}", rawDisplayName), new MessageManager.Replaceable<String>("{player_name}", event.getPlayer().getName()), new MessageManager.Replaceable<String>("{message}", rawText, allowColors)));
        }
    }
}

