/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.jetbrains.annotations.Nullable;

public class GiveMaterialManager {
    private final EssentialZ plugin;
    private final Map<String, Material> normalizedLookup;
    @InjectManager
    private ConfigService configManager;

    public GiveMaterialManager(EssentialZ plugin) {
        this.plugin = plugin;
        this.normalizedLookup = this.buildNormalizedLookup();
    }

    @Nullable
    public Material getMaterialByKey(String key) {
        Map<String, Material> materials = this.getConfigMaterials();
        if (materials.containsKey(key)) {
            return materials.get(key);
        }
        return this.parseMaterial(key);
    }

    public List<String> getPossibleMaterials() {
        List configMaterials = this.getConfigMaterials().keySet().stream().toList();
        List<String> vanillaMaterials = Stream.of(Material.values()).filter(Material::isItem).map(Enum::name).map(String::toLowerCase).toList();
        List<String> normalizedNames = this.normalizedLookup.keySet().stream().map(String::toLowerCase).toList();
        return Stream.concat(Stream.concat(configMaterials.stream(), vanillaMaterials.stream()), normalizedNames.stream()).distinct().sorted().toList();
    }

    private Map<String, Material> getConfigMaterials() {
        FileConfiguration config = this.configManager.getConfig(EszConfig.MATERIALS);
        return config.getValues(false).entrySet().stream().filter(entry -> entry.getValue() instanceof String).map(entry -> {
            String key = (String)entry.getKey();
            String materialName = (String)entry.getValue();
            Material material = this.parseMaterial(materialName);
            if (material == null) {
                this.plugin.getLogger().warning("Invalid material '" + materialName + "' for key '" + key + "' in materials config.");
            }
            return new AbstractMap.SimpleEntry<String, Material>(key, material);
        }).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Material parseMaterial(String name) {
        if (name == null) {
            return null;
        }
        String normalized = this.normalize(name);
        return this.normalizedLookup.get(normalized);
    }

    private String normalize(String name) {
        return name.replaceAll("[^A-Za-z0-9]", "").toUpperCase();
    }

    private Map<String, Material> buildNormalizedLookup() {
        HashMap<String, Material> map = new HashMap<String, Material>();
        Arrays.stream(Material.values()).filter(Material::isItem).forEach(mat -> {
            String normalized = this.normalize(mat.name());
            map.put(normalized, (Material)mat);
        });
        return map;
    }
}

