/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util;

public final class TimeConverter {
    private TimeConverter() {
    }

    public static String ticksToTimeString(long ticks) {
        long totalMinutes = ticks * 60L / 1000L;
        long hours = (totalMinutes / 60L + 6L) % 24L;
        long minutes = totalMinutes % 60L;
        return String.format("%02d:%02d", hours, minutes);
    }

    public static int timeStringToTicks(String timeStr) throws NumberFormatException {
        if ((timeStr = timeStr.toLowerCase()).endsWith("ticks")) {
            return Integer.parseInt(timeStr.replace("ticks", "").trim());
        }
        if (timeStr.contains(":")) {
            String[] parts = timeStr.split(":");
            int hours = Integer.parseInt(parts[0].trim());
            int minutes = Integer.parseInt(parts[1].trim());
            return (hours + 18) % 24 * 1000 + minutes * 1000 / 60;
        }
        if (timeStr.endsWith("am") || timeStr.endsWith("pm")) {
            boolean isPM = timeStr.endsWith("pm");
            int hours = Integer.parseInt(timeStr.replace("am", "").replace("pm", "").trim());
            if (isPM && hours != 12) {
                hours += 12;
            }
            if (!isPM && hours == 12) {
                hours = 0;
            }
            return (hours + 18) % 24 * 1000;
        }
        throw new NumberFormatException("Invalid time format");
    }
}

