/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features;

import com.zetaplugins.zetacore.annotations.Manager;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.List;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

@Manager
public class EnchantmentManager {
    public List<Enchantment> getAllEnchantments() {
        Registry enchantments = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
        return enchantments.stream().toList();
    }

    public List<String> getAllEnchantmentNames() {
        Registry enchantments = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
        return enchantments.stream().map(enchantment -> enchantment.getKey().asString()).map(s -> s.replace("minecraft:", "")).toList();
    }

    public Enchantment getEnchantmentByKeyName(String keyName) {
        if (keyName == null || keyName.isEmpty()) {
            return null;
        }
        Object formattedKeyName = keyName.contains(":") ? keyName : "minecraft:" + keyName;
        Registry enchantments = RegistryAccess.registryAccess().getRegistry(RegistryKey.ENCHANTMENT);
        return (Enchantment)enchantments.get(Key.key((String)formattedKeyName));
    }

    public List<String> getEnchantmentKeyNamesFromItem(ItemStack item) {
        Set enchantments = item.getEnchantments().keySet();
        return enchantments.stream().map(enchantment -> enchantment.getKey().asString()).map(s -> s.replace("minecraft:", "")).toList();
    }
}

