/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.SpawnManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.util.LocationDeserializationException;
import java.util.List;
import java.util.logging.Level;
import org.bukkit.Location;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

@AutoRegisterCommand(commands={"spawn"}, permission="essentialz.spawn", description="Teleports you to the server spawn point.", usage="/spawn")
public class SpawnCommand
extends EszCommand {
    @InjectManager
    private SpawnManager spawnManager;

    public SpawnCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList argumentList) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        try {
            Location spawnLocation = this.spawnManager.getSpawnLocation();
            player.teleport(spawnLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
            return true;
        }
        catch (LocationDeserializationException e) {
            ((EssentialZ)((Object)this.getPlugin())).getLogger().log(Level.WARNING, "Failed to teleport player to spawn: " + e.getMessage());
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NO_SPAWN_SET, new MessageManager.Replaceable[0]));
            return true;
        }
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList argumentList) {
        return List.of();
    }
}

