/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.main.MainConfig;
import com.zetaplugins.essentialz.inventory.holders.UnmodifiableEnderchestInventoryHolder;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"enderchest"}, permission="essentialz.enderchest", description="Opens your enderchest or another player's enderchest.", usage="/enderchest [player]", aliases={"ec"})
public class EnderchestCommand
extends EszCommand {
    @InjectManager
    private ConfigService configService;

    public EnderchestCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList args) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        boolean shouldPlaySound = this.configService.getConfig(MainConfig.class).isEnderchestSound();
        if (args.size() == 0) {
            if (shouldPlaySound) {
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
            }
            player.openInventory(player.getEnderChest());
            return true;
        }
        if (!Permission.ENDERCHEST_OTHERS.has((Permissible)commandSender)) {
            throw new CommandPermissionException(Permission.ENDERCHEST_OTHERS.getNode());
        }
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.PLAYER_NOT_FOUND, new MessageManager.Replaceable[0]));
            return true;
        }
        if (Permission.ENDERCHEST_OTHERS_MODIFY.has((Permissible)player)) {
            if (shouldPlaySound) {
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
            }
            player.openInventory(targetPlayer.getEnderChest());
        } else {
            Inventory inv = Bukkit.createInventory((InventoryHolder)new UnmodifiableEnderchestInventoryHolder(player.getUniqueId()), (InventoryType)InventoryType.ENDER_CHEST);
            inv.setContents(targetPlayer.getEnderChest().getContents());
            if (shouldPlaySound) {
                player.playSound(player.getLocation(), Sound.BLOCK_ENDER_CHEST_OPEN, 1.0f, 1.0f);
            }
            player.openInventory(inv);
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.ENDERCHEST_OTHERS.has((Permissible)commandSender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

