/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz;

import com.zetaplugins.essentialz.config.chat.ChatConfig;
import com.zetaplugins.essentialz.config.economy.EconomyConfig;
import com.zetaplugins.essentialz.config.main.MainConfig;
import com.zetaplugins.essentialz.config.storage.StorageConfig;
import com.zetaplugins.essentialz.features.economy.VaultEconomyImplProvider;
import com.zetaplugins.essentialz.features.economy.manager.BuiltinEconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.UnusedEconomyManager;
import com.zetaplugins.essentialz.features.economy.manager.VaultEconomyManager;
import com.zetaplugins.essentialz.features.papi.EconomyPlaceholders;
import com.zetaplugins.essentialz.features.papi.OtherPlaceholders;
import com.zetaplugins.essentialz.storage.MySQLStorage;
import com.zetaplugins.essentialz.storage.SQLiteStorage;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.ZetaCorePlugin;
import com.zetaplugins.zetacore.services.bStats.Metrics;
import com.zetaplugins.zetacore.services.commands.AutoCommandRegistrar;
import com.zetaplugins.zetacore.services.config.ConfigService;
import com.zetaplugins.zetacore.services.di.ManagerRegistry;
import com.zetaplugins.zetacore.services.events.AutoEventRegistrar;
import com.zetaplugins.zetacore.services.papi.PapiExpansionService;
import com.zetaplugins.zetacore.services.updatechecker.HangarUpdateChecker;
import com.zetaplugins.zetacore.services.updatechecker.UpdateChecker;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;

public final class EssentialZ
extends ZetaCorePlugin {
    public static final UUID CONSOLE_UUID = UUID.fromString("00000000-0000-0000-0000-000000000000");
    private static final String PACKAGE_PREFIX = "com.zetaplugins.essentialz";
    private static final List<String> ECONOMY_COMMANDS = List.of("balance", "pay", "baltop");
    private ConfigService configManager;
    private ManagerRegistry managerRegistry;
    private final boolean hasPlaceholderApi = Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    private final boolean hasVault = Bukkit.getPluginManager().getPlugin("Vault") != null;

    public void onEnable() {
        Permission.registerAll();
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.configManager = new ConfigService(this);
        this.managerRegistry = new ManagerRegistry(this, true, PACKAGE_PREFIX);
        this.managerRegistry.registerInstance(this.configManager);
        this.managerRegistry.registerInstance(Storage.class, this.createPlayerDataStorage());
        this.initUpdateChecker();
        this.initEconomy();
        this.registerCommands();
        this.registerListeners();
        this.initPlaceholderAPI();
        this.initBstats();
        this.getLogger().info("EssentialZ enabled!");
    }

    public void onDisable() {
        this.getLogger().info("EssentialZ disabled!");
    }

    private void initUpdateChecker() {
        HangarUpdateChecker updateChecker = new HangarUpdateChecker(this, "KartoffelChipss", "EssentialZ");
        this.managerRegistry.registerInstance(UpdateChecker.class, updateChecker);
        ((UpdateChecker)updateChecker).checkForUpdates(true);
    }

    private void initEconomy() {
        boolean economyEnabled = this.configManager.getConfig(EconomyConfig.class).isEnabled();
        if (this.hasVault && economyEnabled) {
            this.getLogger().info("Vault detected, enabling Vault economy support.");
            VaultEconomyImplProvider.register(this, this.managerRegistry);
            this.managerRegistry.registerInstance(EconomyManager.class, new VaultEconomyManager());
        } else if (economyEnabled) {
            this.getLogger().warning("Vault not detected, using built-in economy manager.");
            this.managerRegistry.registerInstance(EconomyManager.class, new BuiltinEconomyManager());
        } else {
            this.getLogger().info("Economy system disabled.");
            this.managerRegistry.registerInstance(EconomyManager.class, new UnusedEconomyManager());
        }
    }

    private Storage createPlayerDataStorage() {
        return switch (this.configManager.getConfig(StorageConfig.class).getType().toLowerCase()) {
            case "mysql" -> {
                this.getLogger().info("Using MySQL storage");
                yield new MySQLStorage(this, this.configManager.getConfig(StorageConfig.class));
            }
            case "sqlite" -> {
                this.getLogger().info("Using SQLite storage");
                yield new SQLiteStorage(this);
            }
            default -> {
                this.getLogger().warning("Invalid storage type in config.yml! Using SQLite storage as fallback.");
                yield new SQLiteStorage(this);
            }
        };
    }

    private void registerCommands() {
        List<String> registeredCommands = new AutoCommandRegistrar.Builder().setPlugin(this).setPackagePrefix(PACKAGE_PREFIX).setManagerRegistry(this.managerRegistry).build().registerAllCommands(this::shouldRegisterCommand);
        FileConfiguration config = this.configManager.getConfig(EszConfig.COMMANDS);
        registeredCommands.sort(String::compareTo);
        for (String command : registeredCommands) {
            if (config.contains(command)) continue;
            config.set(command, (Object)true);
        }
        this.configManager.saveConfig(EszConfig.COMMANDS, config);
        this.getLogger().info("Registered " + registeredCommands.size() + " commands.");
    }

    private void registerListeners() {
        List<String> registeredEventListeners = new AutoEventRegistrar.Builder().setPlugin(this).setPackagePrefix(PACKAGE_PREFIX).setManagerRegistry(this.managerRegistry).build().registerAllListeners();
        this.getLogger().info("Registered " + registeredEventListeners.size() + " event listeners.");
    }

    private boolean shouldRegisterCommand(String commandName) {
        boolean economyEnabled = this.configManager.getConfig(EconomyConfig.class).isEnabled();
        if (ECONOMY_COMMANDS.contains(commandName) && !economyEnabled) {
            return false;
        }
        return this.configManager.getConfig(EszConfig.COMMANDS).getBoolean(commandName, true);
    }

    private void initPlaceholderAPI() {
        if (!this.hasPlaceholderApi) {
            return;
        }
        boolean success = new PapiExpansionService(this).setIdentifier("essentialz").setAuthor("ZetaPlugins").addAnnotatedPlaceholders(this.managerRegistry.getOrCreate(EconomyPlaceholders.class)).addAnnotatedPlaceholders(this.managerRegistry.getOrCreate(OtherPlaceholders.class)).register();
        if (success) {
            this.getLogger().info("PlaceholderAPI expansion registered successfully.");
        } else {
            this.getLogger().warning("Failed to register PlaceholderAPI expansion.");
        }
    }

    private void initBstats() {
        int pluginId = 28226;
        Metrics metrics = this.createBStatsMetrics(28226);
        MainConfig mainConfig = this.configManager.getConfig(MainConfig.class);
        metrics.addCustomChart(new Metrics.SimplePie("storageType", () -> this.configManager.getConfig(StorageConfig.class).getType()));
        metrics.addCustomChart(new Metrics.SimplePie("language", mainConfig::getLanguage));
        metrics.addCustomChart(new Metrics.SimplePie("economySystem", () -> {
            EconomyManager economyManager = this.managerRegistry.getOrCreate(EconomyManager.class);
            if (economyManager instanceof VaultEconomyManager) {
                return "vault";
            }
            if (economyManager instanceof BuiltinEconomyManager) {
                return "builtin";
            }
            return "disabled";
        }));
        metrics.addCustomChart(new Metrics.SimplePie("chatEnabled", () -> {
            boolean chatEnabled = this.configManager.getConfig(ChatConfig.class).isEnableCustomChat();
            return chatEnabled ? "true" : "false";
        }));
        this.getLogger().info("bStats metrics initialized.");
    }
}

