/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.papi;

import com.zetaplugins.zetacore.annotations.Papi;
import com.zetaplugins.zetacore.annotations.PapiParam;
import com.zetaplugins.zetacore.services.papi.PatternPlaceholderFunction;
import com.zetaplugins.zetacore.services.papi.PlaceholderFunction;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansionService {
    private String identifier;
    private String author;
    private String version;
    private Map<String, PlaceholderFunction> placeholders;
    private List<PatternEntry> patternPlaceholders = new ArrayList<PatternEntry>();
    private Logger logger;
    private String playerNotFoundMessage = "PlayerNotFound";
    private String playerNotOnlineMessage = "PlayerNotOnline";

    public PapiExpansionService() {
        this.placeholders = new HashMap<String, PlaceholderFunction>();
    }

    public PapiExpansionService(String identifier, String author, String version, Logger logger) {
        this.identifier = identifier;
        this.author = author;
        this.version = version;
        this.placeholders = new HashMap<String, PlaceholderFunction>();
        this.logger = logger;
    }

    public PapiExpansionService(JavaPlugin plugin) {
        this.identifier = plugin.getName().toLowerCase();
        this.author = plugin.getDescription().getAuthors().isEmpty() ? "Unknown" : (String)plugin.getDescription().getAuthors().get(0);
        this.version = plugin.getDescription().getVersion();
        this.placeholders = new HashMap<String, PlaceholderFunction>();
        this.logger = plugin.getLogger();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public PapiExpansionService setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getAuthor() {
        return this.author;
    }

    public PapiExpansionService setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PapiExpansionService setVersion(String version) {
        this.version = version;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PapiExpansionService setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public String getPlayerNotFoundMessage() {
        return this.playerNotFoundMessage;
    }

    public PapiExpansionService setPlayerNotFoundMessage(@Nullable String playerNotFoundMessage) {
        this.playerNotFoundMessage = playerNotFoundMessage;
        return this;
    }

    public String getPlayerNotOnlineMessage() {
        return this.playerNotOnlineMessage;
    }

    public PapiExpansionService setPlayerNotOnlineMessage(@Nullable String playerNotOnlineMessage) {
        this.playerNotOnlineMessage = playerNotOnlineMessage;
        return this;
    }

    public Map<String, PlaceholderFunction> getPlaceholders() {
        return this.placeholders;
    }

    public PapiExpansionService setPlaceholders(Map<String, PlaceholderFunction> placeholders) {
        this.placeholders = placeholders;
        return this;
    }

    public PapiExpansionService addPlaceholder(String key, PlaceholderFunction function) {
        this.placeholders.put(key, function);
        return this;
    }

    public PapiExpansionService addAnnotatedPlaceholders(Object obj) {
        Class<?> clazz = obj.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Papi.class)) continue;
            Papi annotation = method.getAnnotation(Papi.class);
            String placeholderIdentifier = annotation.identifier();
            method.setAccessible(true);
            if (!placeholderIdentifier.contains("{")) {
                PlaceholderFunction pf = this.createPlaceholderFunctionForMethod(obj, method, placeholderIdentifier);
                this.addPlaceholder(placeholderIdentifier, pf);
                continue;
            }
            this.patternPlaceholders.add(this.createPatternEntryForMethod(obj, method, placeholderIdentifier));
        }
        return this;
    }

    private PlaceholderFunction createPlaceholderFunctionForMethod(Object obj, Method method, String placeholderIdentifier) {
        return (player, identifier) -> {
            try {
                if (method.getParameterCount() == 0) {
                    return Objects.toString(method.invoke(obj, new Object[0]), null);
                }
                if (method.getParameterCount() == 1) {
                    Class<?> paramType = method.getParameterTypes()[0];
                    if (paramType == OfflinePlayer.class) {
                        return (String)method.invoke(obj, player);
                    }
                    if (paramType == Player.class) {
                        if (!player.isOnline()) {
                            return this.playerNotOnlineMessage;
                        }
                        return (String)method.invoke(obj, player.getPlayer());
                    }
                    if (paramType == String.class) {
                        return (String)method.invoke(obj, player.getName());
                    }
                    throw new IllegalArgumentException("Unsupported parameter type for Papi method: " + paramType.getName());
                }
                throw new IllegalArgumentException("Papi method must have 0 or 1 parameters.");
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.log(Level.SEVERE, "Error executing PAPI placeholder method for identifier '" + placeholderIdentifier + "': " + e.getMessage(), e);
                } else {
                    e.printStackTrace();
                }
                return null;
            }
        };
    }

    private PatternEntry createPatternEntryForMethod(Object obj, Method method, String placeholderIdentifier) {
        Pair<Pattern, String[]> compiled = PapiExpansionService.compilePattern(placeholderIdentifier);
        Pattern regex = compiled.key();
        String[] paramNames = compiled.value();
        PatternPlaceholderFunction pFunc = (player, identifier1, args) -> {
            try {
                Parameter[] params;
                ArrayList<Object> invokeArgs = new ArrayList<Object>();
                for (Parameter param : params = method.getParameters()) {
                    Class<?> t = param.getType();
                    PapiParam anno = param.getAnnotation(PapiParam.class);
                    if (anno != null) {
                        String name = anno.value();
                        int idx = -1;
                        for (int k = 0; k < paramNames.length; ++k) {
                            if (!paramNames[k].equals(name)) continue;
                            idx = k;
                            break;
                        }
                        if (idx == -1) {
                            throw new IllegalArgumentException("Method " + method.getName() + " expects Papi param '" + name + "' which is not present in pattern " + placeholderIdentifier);
                        }
                        String raw = args[idx];
                        invokeArgs.add(PapiExpansionService.convertStringToType(raw, t, method, placeholderIdentifier));
                        continue;
                    }
                    if (t == OfflinePlayer.class) {
                        invokeArgs.add(player);
                        continue;
                    }
                    if (t == Player.class) {
                        if (!player.isOnline()) {
                            return this.playerNotOnlineMessage;
                        }
                        invokeArgs.add(player.getPlayer());
                        continue;
                    }
                    if (t == String.class) {
                        invokeArgs.add(player.getName());
                        continue;
                    }
                    throw new IllegalArgumentException("Unsupported unannotated parameter type: " + t.getName() + " in method " + method.getName());
                }
                Object result = method.invoke(obj, invokeArgs.toArray());
                return result == null ? null : String.valueOf(result);
            }
            catch (Exception e) {
                if (this.logger != null) {
                    this.logger.log(Level.SEVERE, "Error executing patterned PAPI method for '" + placeholderIdentifier + "': " + e.getMessage(), e);
                } else {
                    e.printStackTrace();
                }
                return null;
            }
        };
        return new PatternEntry(regex, paramNames, pFunc);
    }

    private static Object convertStringToType(String raw, Class<?> targetType, Method method, String placeholderIdentifier) {
        if (targetType == String.class) {
            return raw;
        }
        if (targetType == Integer.TYPE || targetType == Integer.class) {
            try {
                return Integer.parseInt(raw);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse int param '" + raw + "' for method " + method.getName() + " (pattern: " + placeholderIdentifier + ")", ex);
            }
        }
        if (targetType == Long.TYPE || targetType == Long.class) {
            try {
                return Long.parseLong(raw);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse long param '" + raw + "' for method " + method.getName() + " (pattern: " + placeholderIdentifier + ")", ex);
            }
        }
        if (targetType == Double.TYPE || targetType == Double.class) {
            try {
                return Double.parseDouble(raw);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse double param '" + raw + "' for method " + method.getName() + " (pattern: " + placeholderIdentifier + ")", ex);
            }
        }
        if (targetType == Boolean.TYPE || targetType == Boolean.class) {
            return Boolean.parseBoolean(raw);
        }
        if (targetType == Float.TYPE || targetType == Float.class) {
            try {
                return Float.valueOf(Float.parseFloat(raw));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Failed to parse float param '" + raw + "' for method " + method.getName() + " (pattern: " + placeholderIdentifier + ")", ex);
            }
        }
        throw new IllegalArgumentException("Unsupported parameter type for @PapiParam: " + targetType.getName() + " in method " + method.getName());
    }

    public static boolean hasPapi() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public boolean register() throws IllegalStateException {
        if (this.identifier == null || this.author == null || this.version == null || this.placeholders == null) {
            throw new IllegalStateException("Identifier, author, version, and placeholders must be set before registering the expansion.");
        }
        if (!PapiExpansionService.hasPapi()) {
            return false;
        }
        PlaceholderExpansion expansion = new PlaceholderExpansion(){

            @NotNull
            public String getIdentifier() {
                return PapiExpansionService.this.identifier;
            }

            @NotNull
            public String getAuthor() {
                return PapiExpansionService.this.author;
            }

            @NotNull
            public String getVersion() {
                return PapiExpansionService.this.version;
            }

            public String onRequest(OfflinePlayer player, @NotNull String identifier) {
                if (player == null) {
                    return PapiExpansionService.this.playerNotFoundMessage;
                }
                PlaceholderFunction exact = PapiExpansionService.this.placeholders.get(identifier);
                if (exact != null) {
                    return exact.apply(player, identifier);
                }
                for (PatternEntry pe : PapiExpansionService.this.patternPlaceholders) {
                    Matcher m = pe.getPattern().matcher(identifier);
                    if (!m.matches()) continue;
                    String[] args = new String[pe.getParamNames().length];
                    for (int k = 0; k < args.length; ++k) {
                        args[k] = m.group(k + 1);
                    }
                    return pe.getFunction().apply(player, identifier, args);
                }
                return null;
            }
        };
        if (!expansion.canRegister()) {
            return false;
        }
        expansion.register();
        return true;
    }

    private static Pair<Pattern, String[]> compilePattern(String template) {
        ArrayList<String> names = new ArrayList<String>();
        StringBuilder regex = new StringBuilder();
        regex.append("^");
        int i = 0;
        while (i < template.length()) {
            char c = template.charAt(i);
            if (c == '{') {
                int j = template.indexOf(125, i);
                if (j == -1) {
                    throw new IllegalArgumentException("Unclosed { in pattern: " + template);
                }
                String name = template.substring(i + 1, j);
                names.add(name);
                regex.append("([^_]+)");
                i = j + 1;
                continue;
            }
            if ("\\.^$|?*+[](){}".indexOf(c) >= 0) {
                regex.append("\\");
            }
            regex.append(c);
            ++i;
        }
        regex.append("$");
        return new Pair<Pattern, String[]>(Pattern.compile(regex.toString()), names.toArray(new String[0]));
    }

    private static class PatternEntry {
        private final Pattern pattern;
        private final String[] paramNames;
        private final PatternPlaceholderFunction function;

        PatternEntry(Pattern pattern, String[] paramNames, PatternPlaceholderFunction function) {
            this.pattern = pattern;
            this.paramNames = paramNames;
            this.function = function;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String[] getParamNames() {
            return this.paramNames;
        }

        public PatternPlaceholderFunction getFunction() {
            return this.function;
        }
    }

    private record Pair<K, V>(K key, V value) {
    }
}

