/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.economy;

import com.zetaplugins.essentialz.config.economy.CurrencyFormatConfigSection;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;

public class EconomyUtil {
    private static final Map<String, Double> SUFFIX_MULTIPLIERS = Map.of("K", 1000.0, "M", 1000000.0, "B", 1.0E9, "T", 1.0E12, "Q", 1.0E15);

    private EconomyUtil() {
    }

    public static String formatCurrency(double amount, CurrencyFormatConfigSection config) {
        return EconomyUtil.formatCurrency(amount, config.getSymbol(), config.getDecimalPlaces(), config.getThousandSeparator(), config.getDecimalSeparator(), config.getSymbolPosition());
    }

    public static String formatCurrency(double amount, FileConfiguration config) {
        String symbol = config.getString("currencyFormat.symbol", "$");
        int decimalPlaces = config.getInt("currencyFormat.decimalPlaces", 2);
        String thousandSeparator = config.getString("currencyFormat.thousandSeparator", ",");
        String decimalSeparator = config.getString("currencyFormat.decimalSeparator", ".");
        String symbolPosition = config.getString("currencyFormat.symbolPosition", "before");
        return EconomyUtil.formatCurrency(amount, symbol, decimalPlaces, thousandSeparator, decimalSeparator, symbolPosition);
    }

    public static String formatCurrency(double amount, String symbol, int decimalPlaces, String thousandSeparator, String decimalSeparator, String symbolPosition) {
        String formatString = "%,." + decimalPlaces + "f";
        String formattedAmount = String.format(formatString, amount);
        if (!thousandSeparator.equals(",")) {
            formattedAmount = formattedAmount.replace(",", "TEMP_THOUSAND_SEP");
        }
        if (!decimalSeparator.equals(".")) {
            formattedAmount = formattedAmount.replace(".", decimalSeparator);
        }
        if (!thousandSeparator.equals(",")) {
            formattedAmount = formattedAmount.replace("TEMP_THOUSAND_SEP", thousandSeparator);
        }
        if (symbolPosition.equalsIgnoreCase("before")) {
            return symbol + formattedAmount;
        }
        return formattedAmount + symbol;
    }

    public static double parseNumber(String input, CurrencyFormatConfigSection config) throws NumberFormatException {
        String sanitizedInput = input.replace(config.getSymbol(), "").replace(config.getThousandSeparator(), "").replace(config.getDecimalSeparator(), ".").trim();
        for (Map.Entry<String, Double> entry : SUFFIX_MULTIPLIERS.entrySet()) {
            String suffix = entry.getKey();
            Double multiplier = entry.getValue();
            if (!sanitizedInput.toUpperCase().endsWith(suffix)) continue;
            String numberPart = sanitizedInput.substring(0, sanitizedInput.length() - suffix.length()).trim();
            return Double.parseDouble(numberPart) * multiplier;
        }
        return Double.parseDouble(sanitizedInput);
    }
}

