/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.worldcontrol.weather;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"weather"}, permission="essentialz.weather", description="Manage the weather in your world.", usage="/weather <clear|rain|thunder> [duration]")
public class WeatherCommand
extends EszCommand {
    public WeatherCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList args) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        if (args.size() < 1) {
            throw new CommandUsageException("/weather <clear|rain|thunder> [duration]");
        }
        String weatherType = args.getString(0, "").toLowerCase();
        if (!(weatherType.equals("clear") || weatherType.equals("rain") || weatherType.equals("thunder"))) {
            throw new CommandUsageException("/weather <clear|rain|thunder> [duration]");
        }
        int duration = 0;
        if (args.size() >= 2) {
            String inputDuration = args.getString(1, "5m");
            try {
                duration = this.parseDurationToTicks(inputDuration);
            }
            catch (NumberFormatException e) {
                commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INVALID_DURATION_FORMAT, new MessageManager.Replaceable[0]));
                return true;
            }
        }
        if (duration < 0) {
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.DURATION_MUST_BE_POSITIVE, new MessageManager.Replaceable[0]));
            return true;
        }
        switch (weatherType) {
            case "clear": {
                player.getWorld().setStorm(false);
                break;
            }
            case "rain": {
                player.getWorld().setStorm(true);
                player.getWorld().setThundering(false);
                break;
            }
            case "thunder": {
                player.getWorld().setStorm(true);
                player.getWorld().setThundering(true);
            }
        }
        if (duration != 0) {
            player.getWorld().setWeatherDuration(duration);
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.WEATHER_CHANGED_TIME, new MessageManager.Replaceable<String>("{weather}", weatherType), new MessageManager.Replaceable<String>("{duration}", String.valueOf(duration / 20))));
        } else {
            commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.WEATHER_CHANGED, new MessageManager.Replaceable<String>("{weather}", weatherType)));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return List.of("clear", "rain", "thunder");
        }
        if (args.getCurrentArgIndex() == 1) {
            return List.of("30s", "1m", "5m", "10m", "30m", "1h");
        }
        return List.of();
    }

    private int parseDurationToTicks(String input) throws NumberFormatException {
        int multiplier;
        if (input.endsWith("s")) {
            multiplier = 20;
            input = input.substring(0, input.length() - 1);
        } else if (input.endsWith("m")) {
            multiplier = 1200;
            input = input.substring(0, input.length() - 1);
        } else if (input.endsWith("h")) {
            multiplier = 72000;
            input = input.substring(0, input.length() - 1);
        } else {
            throw new NumberFormatException("Invalid duration format");
        }
        int value = Integer.parseInt(input);
        return value * multiplier;
    }
}

