/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.SpawnManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"setspawn"}, permission="essentialz.setspawn", description="Sets the server spawn point to your current location.", usage="/setspawn")
public class SetSpawnCommand
extends EszCommand {
    @InjectManager
    private SpawnManager spawnManager;

    public SetSpawnCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList argumentList) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        this.spawnManager.setSpawnLocation(player.getLocation());
        commandSender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SPAWN_SET_SUCCESS, new MessageManager.Replaceable<String>("{x}", String.valueOf(player.getLocation().getBlockX())), new MessageManager.Replaceable<String>("{y}", String.valueOf(player.getLocation().getBlockY())), new MessageManager.Replaceable<String>("{z}", String.valueOf(player.getLocation().getBlockZ()))));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList argumentList) {
        return List.of();
    }
}

