/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage.repositories.player;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.essentialz.storage.repositories.Repository;
import com.zetaplugins.essentialz.storage.repositories.player.PlayerRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;

public class SQLPlayerRepository
extends Repository
implements PlayerRepository {
    public SQLPlayerRepository(EssentialZ plugin, ConnectionPool connectionPool) {
        super(plugin, connectionPool);
    }

    @Override
    public void initializeTable() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                StringBuilder playerTableSql = new StringBuilder();
                playerTableSql.append("CREATE TABLE IF NOT EXISTS players (").append("uuid CHAR(36) PRIMARY KEY, ").append("enableTeamchat BOOLEAN DEFAULT TRUE, ").append("enableDms BOOLEAN DEFAULT TRUE, ").append("balance DOUBLE DEFAULT 0.0").append(");");
                statement.executeUpdate(playerTableSql.toString());
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create players SQLite table:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create players SQLite table:", e);
        }
    }

    @Override
    public void save(PlayerData playerData) {
        if (!playerData.hasChanges()) {
            return;
        }
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            boolean exists = this.checkIfEntryExists(connection, playerData.getUuid());
            if (exists) {
                this.updatePlayerData(connection, playerData);
            } else {
                this.insertPlayerData(connection, playerData);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save player data:", e);
        }
    }

    private boolean insertPlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block8: {
            String insertQuery = "INSERT INTO players (uuid, enableTeamchat, enableDms, balance) VALUES (?, ?, ?, ?)";
            PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO players (uuid, enableTeamchat, enableDms, balance) VALUES (?, ?, ?, ?)");
            try {
                insertStmt.setString(1, playerData.getUuid());
                insertStmt.setBoolean(2, playerData.isEnableTeamchat());
                insertStmt.setBoolean(3, playerData.isEnableDms());
                insertStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (insertStmt == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (insertStmt != null) {
                        try {
                            insertStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to insert player data into SQLite:", e);
                    return false;
                }
            }
            insertStmt.close();
        }
        return bl;
    }

    private boolean updatePlayerData(Connection connection, PlayerData playerData) {
        boolean bl;
        block20: {
            StringBuilder updateQuery = new StringBuilder("UPDATE players SET ");
            ArrayList<Object> params = new ArrayList<Object>();
            for (String field : playerData.getModifiedFields()) {
                updateQuery.append(field).append(" = ?, ");
                switch (field) {
                    case "enableTeamchat": {
                        params.add(playerData.isEnableTeamchat());
                        break;
                    }
                    case "enableDms": {
                        params.add(playerData.isEnableDms());
                        break;
                    }
                    case "balance": {
                        params.add(playerData.getBalance());
                    }
                }
            }
            updateQuery.setLength(updateQuery.length() - 2);
            updateQuery.append(" WHERE uuid = ?");
            params.add(playerData.getUuid());
            PreparedStatement updateStmt = connection.prepareStatement(updateQuery.toString());
            try {
                for (int i = 0; i < params.size(); ++i) {
                    updateStmt.setObject(i + 1, params.get(i));
                }
                updateStmt.executeUpdate();
                playerData.clearModifiedFields();
                bl = true;
                if (updateStmt == null) break block20;
            }
            catch (Throwable throwable) {
                try {
                    if (updateStmt != null) {
                        try {
                            updateStmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to update player data:", e);
                    return false;
                }
            }
            updateStmt.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean checkIfEntryExists(Connection connection, String uuid) {
        String selectQuery = "SELECT 1 FROM players WHERE uuid = ?";
        try (PreparedStatement selectStmt = connection.prepareStatement("SELECT 1 FROM players WHERE uuid = ?");){
            boolean bl;
            block14: {
                selectStmt.setString(1, uuid);
                ResultSet resultSet = selectStmt.executeQuery();
                try {
                    bl = resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to check if player entry exists:", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    @Nullable
    public PlayerData load(UUID uuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 9 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PlayerData mapResultSetToPlayerData(ResultSet resultSet, UUID uuid) throws SQLException {
        PlayerData playerData = new PlayerData(uuid);
        playerData.setEnableTeamchat(resultSet.getBoolean("enableTeamchat"));
        playerData.setEnableDms(resultSet.getBoolean("enableDms"));
        playerData.setBalance(resultSet.getDouble("balance"));
        playerData.clearModifiedFields();
        return playerData;
    }

    @Override
    @Nullable
    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<UUID, Double> getTopBalances(int topN) {
        String sql = "SELECT uuid, balance FROM players ORDER BY balance DESC LIMIT ?";
        LinkedHashMap<UUID, Double> topBalances = new LinkedHashMap<UUID, Double>();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                LinkedHashMap<UUID, Double> linkedHashMap = topBalances;
                return linkedHashMap;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT uuid, balance FROM players ORDER BY balance DESC LIMIT ?");){
                statement.setInt(1, topN);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        UUID uuid = UUID.fromString(resultSet.getString("uuid"));
                        double balance = resultSet.getDouble("balance");
                        topBalances.put(uuid, balance);
                    }
                    return topBalances;
                }
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve top balances from SQLite database:", e);
        }
        return topBalances;
    }
}

