/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage.repositories.ignores;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.essentialz.storage.repositories.Repository;
import com.zetaplugins.essentialz.storage.repositories.ignores.IgnoresRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.UUID;
import java.util.logging.Level;

public class SQLIgnoresRepository
extends Repository
implements IgnoresRepository {
    public SQLIgnoresRepository(EssentialZ plugin, ConnectionPool connectionPool) {
        super(plugin, connectionPool);
    }

    @Override
    public void initializeTable() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                StringBuilder ignoreTableSql = new StringBuilder();
                ignoreTableSql.append("CREATE TABLE IF NOT EXISTS ignores (").append("playerUuid CHAR(36), ").append("targetUuid CHAR(36), ").append("PRIMARY KEY (playerUuid, targetUuid), ").append("FOREIGN KEY (playerUuid) REFERENCES players(uuid) ON DELETE CASCADE, ").append("FOREIGN KEY (targetUuid) REFERENCES players(uuid) ON DELETE CASCADE").append(");");
                statement.executeUpdate(ignoreTableSql.toString());
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create ignores table:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create ignores table:", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean togglePlayerIgnore(UUID playerUuid, UUID targetUuid) {
        String checkQuery = "SELECT 1 FROM ignores WHERE playerUuid = ? AND targetUuid = ?";
        String insertQuery = "INSERT INTO ignores (playerUuid, targetUuid) VALUES (?, ?)";
        String deleteQuery = "DELETE FROM ignores WHERE playerUuid = ? AND targetUuid = ?";
        try {
            boolean bl;
            Connection connection = this.getConnection();
            if (connection == null) {
                boolean bl2 = false;
                return bl2;
            }
            PreparedStatement checkStmt = connection.prepareStatement("SELECT 1 FROM ignores WHERE playerUuid = ? AND targetUuid = ?");
            checkStmt.setString(1, playerUuid.toString());
            checkStmt.setString(2, targetUuid.toString());
            ResultSet resultSet = checkStmt.executeQuery();
            if (resultSet.next()) {
                try (PreparedStatement deleteStmt = connection.prepareStatement("DELETE FROM ignores WHERE playerUuid = ? AND targetUuid = ?");){
                    deleteStmt.setString(1, playerUuid.toString());
                    deleteStmt.setString(2, targetUuid.toString());
                    deleteStmt.executeUpdate();
                    boolean bl3 = false;
                    return bl3;
                }
            }
            try (PreparedStatement insertStmt = connection.prepareStatement("INSERT INTO ignores (playerUuid, targetUuid) VALUES (?, ?)");){
                insertStmt.setString(1, playerUuid.toString());
                insertStmt.setString(2, targetUuid.toString());
                insertStmt.executeUpdate();
                bl = true;
                if (insertStmt == null) return bl;
            }
            return bl;
            finally {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            finally {
                if (checkStmt != null) {
                    checkStmt.close();
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to toggle player ignore status:", e);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isPlayerIgnoring(UUID playerUuid, UUID targetUuid) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

