/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage.repositories.homes;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.essentialz.storage.model.HomeData;
import com.zetaplugins.essentialz.storage.repositories.Repository;
import com.zetaplugins.essentialz.storage.repositories.homes.HomesRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;

public abstract class SQLHomesRepository
extends Repository
implements HomesRepository {
    public SQLHomesRepository(EssentialZ plugin, ConnectionPool connectionPool) {
        super(plugin, connectionPool);
    }

    @Override
    public void initializeTable() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                String sql = "CREATE TABLE IF NOT EXISTS homes (owner CHAR(36) NOT NULL, homeName TEXT NOT NULL, world TEXT NOT NULL, x DOUBLE, y DOUBLE, z DOUBLE, yaw FLOAT, pitch FLOAT, PRIMARY KEY (owner, homeName), FOREIGN KEY (owner) REFERENCES players(uuid) ON DELETE CASCADE);";
                statement.executeUpdate(sql);
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create homes SQL table:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create homes SQL table:", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public HomeData load(UUID owner, String homeName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void save(HomeData homeData) {
        String sql = this.getInserOrReplaceHomeStatement();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, homeData.getOwner().toString());
                statement.setString(2, homeData.getName());
                statement.setString(3, homeData.getWorld());
                statement.setDouble(4, homeData.getX());
                statement.setDouble(5, homeData.getY());
                statement.setDouble(6, homeData.getZ());
                statement.setFloat(7, homeData.getYaw());
                statement.setFloat(8, homeData.getPitch());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save home to SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save home to SQL database:", e);
        }
    }

    protected abstract String getInserOrReplaceHomeStatement();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(UUID owner, String homeName) {
        String sql = "DELETE FROM homes WHERE owner = ? AND homeName = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block18: {
                if (connection == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                PreparedStatement statement = connection.prepareStatement("DELETE FROM homes WHERE owner = ? AND homeName = ?");
                try {
                    statement.setString(1, owner.toString());
                    statement.setString(2, homeName);
                    int rowsAffected = statement.executeUpdate();
                    boolean bl2 = bl = rowsAffected > 0;
                    if (statement == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete home from SQL database:", e);
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete home from SQL database:", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<HomeData> getAllHomes(UUID owner) {
        ArrayList<HomeData> homes = new ArrayList<HomeData>();
        String sql = "SELECT * FROM homes WHERE owner = ?";
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<HomeData> arrayList = homes;
                return arrayList;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT * FROM homes WHERE owner = ?");){
                statement.setString(1, owner.toString());
                statement.setQueryTimeout(30);
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        String homeName = resultSet.getString("homeName");
                        String world = resultSet.getString("world");
                        double x = resultSet.getDouble("x");
                        double y = resultSet.getDouble("y");
                        double z = resultSet.getDouble("z");
                        float yaw = resultSet.getFloat("yaw");
                        float pitch = resultSet.getFloat("pitch");
                        HomeData homeData = new HomeData(owner, homeName, world, x, y, z, yaw, pitch);
                        homes.add(homeData);
                    }
                    return homes;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve homes for owner \"" + owner.toString() + "\"  from SQL database:", e);
                    return homes;
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve homes for owner \"" + owner.toString() + "\"  from SQL database:", e);
                return homes;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve homes for owner \"" + owner.toString() + "\"  from SQL database:", e);
        }
        return homes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getHomeCount(UUID owner) {
        sql = "SELECT COUNT(*) AS homeCount FROM homes WHERE owner = ?";
        try {
            block25: {
                connection = this.getConnection();
                if (connection != null) break block25;
                var4_5 = 0;
                if (connection == null) return var4_5;
                connection.close();
                return var4_5;
            }
            try {
                block26: {
                    block28: {
                        statement = connection.prepareStatement("SELECT COUNT(*) AS homeCount FROM homes WHERE owner = ?");
                        statement.setString(1, owner.toString());
                        statement.setQueryTimeout(30);
                        try {
                            block27: {
                                resultSet = statement.executeQuery();
                                try {
                                    if (!resultSet.next()) break block26;
                                    var6_13 = resultSet.getInt("homeCount");
                                    if (resultSet == null) break block27;
                                }
                                catch (Throwable var6_14) {
                                    if (resultSet == null) throw var6_14;
                                    try {
                                        resultSet.close();
                                        throw var6_14;
                                    }
                                    catch (Throwable var7_16) {
                                        var6_14.addSuppressed(var7_16);
                                    }
                                    throw var6_14;
                                }
                                resultSet.close();
                            }
                            if (statement == null) break block28;
                        }
                        catch (SQLException e) {
                            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to count homes for owner \"" + owner.toString() + "\" from SQL database:", e);
                            return 0;
                        }
                        statement.close();
                    }
                    if (connection == null) return var6_13;
                    connection.close();
                    return var6_13;
                }
                ** try [egrp 6[TRYBLOCK] [11 : 126->272)] { 
lbl51:
                // 1 sources

                if (resultSet == null) return 0;
                resultSet.close();
                return 0;
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to count homes for owner \"" + owner.toString() + "\" from SQL database:", e);
                return 0;
            }
lbl57:
            // 1 sources

            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to count homes for owner \"" + owner.toString() + "\" from SQL database:", e);
        }
        return 0;
    }
}

