/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.economy;

import com.zetaplugins.essentialz.config.economy.CurrencyFormatConfigSection;
import com.zetaplugins.essentialz.config.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.EconomyUtil;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class VaultEconomyImpl
implements Economy {
    private CurrencyFormatConfigSection currencyConfig;
    @InjectManager
    private ConfigService configService;
    @InjectManager
    private Storage storage;

    @PostManagerConstruct
    public void init() {
        this.currencyConfig = this.configService.getConfig(EconomyConfig.class).getCurrencyFormat();
    }

    public boolean isEnabled() {
        return true;
    }

    public String getName() {
        return "EssentialZ";
    }

    public boolean hasBankSupport() {
        return false;
    }

    public int fractionalDigits() {
        return -1;
    }

    public String format(double v) {
        return EconomyUtil.formatCurrency(v, this.currencyConfig);
    }

    public String currencyNamePlural() {
        return this.currencyConfig.getSymbol();
    }

    public String currencyNameSingular() {
        return this.currencyConfig.getSymbol();
    }

    public boolean hasAccount(String s) {
        return this.hasAccount(Bukkit.getOfflinePlayer((String)s));
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer) {
        return this.storage.getPlayerRepository().load(offlinePlayer.getUniqueId()) != null;
    }

    public boolean hasAccount(String s, String s1) {
        return this.hasAccount(s);
    }

    public boolean hasAccount(OfflinePlayer offlinePlayer, String s) {
        return this.hasAccount(offlinePlayer);
    }

    public double getBalance(String s) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)s));
    }

    public double getBalance(OfflinePlayer offlinePlayer) {
        PlayerData playerData = this.storage.getPlayerRepository().load(offlinePlayer.getUniqueId());
        if (playerData == null) {
            return 0.0;
        }
        return playerData.getBalance();
    }

    public double getBalance(String s, String s1) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)s));
    }

    public double getBalance(OfflinePlayer offlinePlayer, String s) {
        return this.getBalance(offlinePlayer);
    }

    public boolean has(String s, double v) {
        return this.has(Bukkit.getOfflinePlayer((String)s), v);
    }

    public boolean has(OfflinePlayer offlinePlayer, double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("Amount cannot be negative");
        }
        return this.getBalance(offlinePlayer) >= v;
    }

    public boolean has(String s, String s1, double v) {
        return this.has(Bukkit.getOfflinePlayer((String)s), s1, v);
    }

    public boolean has(OfflinePlayer offlinePlayer, String s, double v) {
        return this.has(offlinePlayer, v);
    }

    public EconomyResponse withdrawPlayer(String s, double v) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("Amount cannot be negative");
        }
        PlayerData playerData = this.storage.getPlayerRepository().load(offlinePlayer.getUniqueId());
        if (playerData == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account does not exist");
        }
        if (playerData.getBalance() < v) {
            return new EconomyResponse(0.0, playerData.getBalance(), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
        }
        playerData.setBalance(playerData.getBalance() - v);
        this.storage.getPlayerRepository().save(playerData);
        return new EconomyResponse(v, playerData.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse withdrawPlayer(String s, String s1, double v) {
        return this.withdrawPlayer(Bukkit.getOfflinePlayer((String)s), s1, v);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.withdrawPlayer(offlinePlayer, v);
    }

    public EconomyResponse depositPlayer(String s, double v) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)s), v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, double v) {
        if (v < 0.0) {
            throw new IllegalArgumentException("Amount cannot be negative");
        }
        PlayerData playerData = this.storage.getPlayerRepository().load(offlinePlayer.getUniqueId());
        if (playerData == null) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Account does not exist");
        }
        playerData.setBalance(playerData.getBalance() + v);
        this.storage.getPlayerRepository().save(playerData);
        return new EconomyResponse(v, playerData.getBalance(), EconomyResponse.ResponseType.SUCCESS, null);
    }

    public EconomyResponse depositPlayer(String s, String s1, double v) {
        return this.depositPlayer(Bukkit.getOfflinePlayer((String)s), s1, v);
    }

    public EconomyResponse depositPlayer(OfflinePlayer offlinePlayer, String s, double v) {
        return this.depositPlayer(offlinePlayer, v);
    }

    public EconomyResponse createBank(String s, String s1) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse createBank(String s, OfflinePlayer offlinePlayer) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse deleteBank(String s) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse bankBalance(String s) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse bankHas(String s, double v) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse bankWithdraw(String s, double v) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse bankDeposit(String s, double v) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse isBankOwner(String s, String s1) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse isBankOwner(String s, OfflinePlayer offlinePlayer) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse isBankMember(String s, String s1) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public EconomyResponse isBankMember(String s, OfflinePlayer offlinePlayer) {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public List<String> getBanks() {
        throw new UnsupportedOperationException("Bank support is not implemented");
    }

    public boolean createPlayerAccount(String s) {
        throw new UnsupportedOperationException("User accounts are created automatically");
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer) {
        throw new UnsupportedOperationException("User accounts are created automatically");
    }

    public boolean createPlayerAccount(String s, String s1) {
        throw new UnsupportedOperationException("User accounts are created automatically");
    }

    public boolean createPlayerAccount(OfflinePlayer offlinePlayer, String s) {
        throw new UnsupportedOperationException("User accounts are created automatically");
    }
}

