/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement.homes;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.HomeData;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"homes"}, permission="essentialz.homelist", description="List all your homes.", usage="/homes")
public class HomesCommand
extends EszCommand {
    @InjectManager
    private Storage storage;

    public HomesCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender commandSender, Command command, String s, ArgumentList argumentList) throws CommandException {
        if (!(commandSender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)commandSender;
        List<HomeData> homes = this.storage.getHomesRepository().getAllHomes(player.getUniqueId());
        if (homes.isEmpty()) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NO_HOMES_SET, new MessageManager.Replaceable[0]));
            return true;
        }
        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HOMES_LIST_HEADER, false, new MessageManager.Replaceable[0]));
        for (HomeData home : homes) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HOMES_LIST_ENTRY, false, new MessageManager.Replaceable<String>("{index}", String.valueOf(homes.indexOf(home) + 1)), new MessageManager.Replaceable<String>("{homeName}", home.getName()), new MessageManager.Replaceable<String>("{x}", String.valueOf(home.getLocation().getBlockX())), new MessageManager.Replaceable<String>("{y}", String.valueOf(home.getLocation().getBlockY())), new MessageManager.Replaceable<String>("{z}", String.valueOf(home.getLocation().getBlockZ()))));
        }
        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.HOMES_LIST_FOOTER, false, new MessageManager.Replaceable[0]));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender commandSender, Command command, ArgumentList argumentList) {
        return List.of();
    }
}

