/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.economy;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.EconomyUtil;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.Arrays;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"balance"}, description="Check your balance or another player's balance or modify it if you have permission.", usage="/balance [player] <get|set|add|remove> <amount>", permission="essentialz.balance", aliases={"bal", "money"})
public class BalanceCommand
extends EszCommand {
    @InjectManager
    private EconomyManager economyManager;
    @InjectManager
    private ConfigService configService;

    public BalanceCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String s, ArgumentList args) throws CommandException {
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        Action action = args.getEnumIgnoreCase(1, Action.class, Action.GET);
        String amountString = args.getString(2, "0");
        try {
            Player player;
            boolean isOtherPlayer;
            double amount = EconomyUtil.parseNumber(amountString, this.configService.getConfig(EconomyConfig.class).getCurrencyFormat());
            boolean bl = isOtherPlayer = targetPlayer != null && (!(sender instanceof Player) || !(player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()));
            if (isOtherPlayer && action.equals((Object)Action.GET) && !Permission.BALANCE_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.BALANCE_OTHERS.getNode());
            }
            if (!isOtherPlayer && !(sender instanceof Player)) {
                throw new CommandSenderMustBeOrSpecifyPlayerException();
            }
            player = isOtherPlayer ? targetPlayer : (Player)sender;
            switch (action.ordinal()) {
                case 0: {
                    double balance = this.economyManager.getBalance((OfflinePlayer)player);
                    if (isOtherPlayer) {
                        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.OTHER_PLAYER_BALANCE, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{balance}", this.economyManager.format(balance))));
                    } else {
                        player.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.YOUR_BALANCE, new MessageManager.Replaceable<String>("{balance}", this.economyManager.format(balance))));
                    }
                    return true;
                }
                case 1: {
                    if (!Permission.BALANCE_MODIFY.has((Permissible)sender)) {
                        throw new CommandPermissionException(Permission.BALANCE_MODIFY.getNode());
                    }
                    this.economyManager.setBalance((OfflinePlayer)player, amount);
                    sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.SET_BALANCE, new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{balance}", this.economyManager.format(amount))));
                    return true;
                }
                case 2: {
                    if (!Permission.BALANCE_MODIFY.has((Permissible)sender)) {
                        throw new CommandPermissionException(Permission.BALANCE_MODIFY.getNode());
                    }
                    this.economyManager.deposit((OfflinePlayer)player, amount);
                    sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ADD_BALANCE, new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{amount}", this.economyManager.format(amount))));
                    return true;
                }
                case 3: {
                    if (!Permission.BALANCE_MODIFY.has((Permissible)sender)) {
                        throw new CommandPermissionException(Permission.BALANCE_MODIFY.getNode());
                    }
                    boolean success = this.economyManager.withdraw((OfflinePlayer)player, amount);
                    if (success) {
                        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.REMOVE_BALANCE, new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{amount}", this.economyManager.format(amount))));
                        break;
                    }
                    sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INSUFFICIENT_FUNDS_TO_WITHDRAW, new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{amount}", this.economyManager.format(amount))));
                }
            }
            return false;
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.INVALID_NUMBER, new MessageManager.Replaceable<String>("{number}", amountString)));
            return false;
        }
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        Action action;
        if (args.getCurrentArgIndex() == 0 && (Permission.BALANCE_OTHERS.has((Permissible)sender) || Permission.BALANCE_MODIFY.has((Permissible)sender))) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            List<String> actions = null;
            actions = !Permission.BALANCE_MODIFY.has((Permissible)sender) ? List.of(Action.GET.name().toLowerCase()) : Arrays.stream(Action.values()).map(Enum::name).map(String::toLowerCase).toList();
            return this.getDisplayOptions(actions, args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 2 && (action = (Action)args.getEnum(1, Action.class, null)) != null && action != Action.GET) {
            return List.of("<amount>");
        }
        return List.of();
    }

    private static enum Action {
        GET,
        SET,
        ADD,
        REMOVE;

    }
}

