/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.RulesManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

@AutoRegisterCommand(commands={"rules"}, permission="essentialz.rules", description="Displays the server rules to the sender.", usage="/rules")
public class RulesCommand
extends EszCommand {
    @InjectManager
    private MessageManager messageManager;
    @InjectManager
    private RulesManager rulesManager;

    public RulesCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String s, ArgumentList args) throws CommandException {
        if (!this.rulesManager.fileExists()) {
            sender.sendMessage(this.messageManager.getAndFormatMsg(PluginMessage.NO_RULES_FILE_FOUND, new MessageManager.Replaceable[0]));
            return true;
        }
        List<String> lines = this.rulesManager.getLines();
        if (lines == null) {
            sender.sendMessage(this.messageManager.getAndFormatMsg(PluginMessage.ERROR_READING_RULES_FILE, new MessageManager.Replaceable[0]));
            return true;
        }
        for (String line : lines) {
            sender.sendMessage(this.messageManager.formatMsg(line, new MessageManager.Replaceable[0]));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        return List.of();
    }
}

