/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.config;

import com.zetaplugins.zetacore.annotations.NestedConfig;
import com.zetaplugins.zetacore.annotations.PluginConfig;
import com.zetaplugins.zetacore.services.config.ConfigMappingException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigMapper {
    public static String toFileName(Class<?> configClass) {
        if (!configClass.isAnnotationPresent(PluginConfig.class)) {
            throw new IllegalArgumentException("Class " + configClass.getName() + " is not annotated with @ConfigProperties");
        }
        PluginConfig annotation = configClass.getAnnotation(PluginConfig.class);
        return annotation.value();
    }

    public static <T> T map(FileConfiguration fileConfiguration, Class<T> configClass) throws ConfigMappingException {
        try {
            T instance = configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigMapper.mapSection((ConfigurationSection)fileConfiguration, instance);
            return instance;
        }
        catch (Exception e) {
            throw new ConfigMappingException("Failed to map configuration to class " + configClass.getName(), e);
        }
    }

    private static <T> void mapSection(ConfigurationSection section, T instance) throws Exception {
        Class<?> configClass = instance.getClass();
        for (Field field : configClass.getDeclaredFields()) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (fieldType.isAnnotationPresent(NestedConfig.class)) {
                ConfigurationSection nestedSection = section.getConfigurationSection(field.getName());
                if (nestedSection == null) continue;
                Object nestedInstance = fieldType.getConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigMapper.mapSection(nestedSection, nestedInstance);
                field.set(instance, nestedInstance);
                continue;
            }
            if (ConfigMapper.isListType(fieldType)) {
                Object rawListObj = section.get(field.getName());
                if (rawListObj instanceof List) {
                    List rawList = (List)rawListObj;
                    List<Object> mappedList = ConfigMapper.convertList(field.getGenericType(), rawList, field.getName());
                    field.set(instance, mappedList);
                    continue;
                }
                if (rawListObj == null) continue;
                throw new ConfigMappingException("Field '" + field.getName() + "' expected a List but got " + rawListObj.getClass().getName());
            }
            if (ConfigMapper.isMapType(fieldType)) {
                Map<Object, Object> mapped;
                Object rawMap = section.get(field.getName());
                ConfigurationSection rawSection = section.getConfigurationSection(field.getName());
                if (rawSection != null) {
                    mapped = ConfigMapper.convertMap(field.getGenericType(), rawSection, field.getName());
                    field.set(instance, mapped);
                    continue;
                }
                if (rawMap instanceof LinkedHashMap || rawMap instanceof Map) {
                    mapped = ConfigMapper.convertMap(field.getGenericType(), rawMap, field.getName());
                    field.set(instance, mapped);
                    continue;
                }
                if (rawMap == null) continue;
                throw new ConfigMappingException("Field '" + field.getName() + "' expected a Map but got " + rawMap.getClass().getName());
            }
            if (ConfigMapper.isSimpleType(fieldType)) {
                Object value = section.get(field.getName());
                if (value == null) continue;
                field.set(instance, value);
                continue;
            }
            throw new ConfigMappingException("Cannot map field '" + field.getName() + "' of type " + fieldType.getName() + ". Field must be annotated with @NestedConfig or be a primitive/List/Map/String.");
        }
    }

    private static void mapFromMap(LinkedHashMap<?, ?> map, Object instance) throws Exception {
        Class<?> clazz = instance.getClass();
        for (Field field : clazz.getDeclaredFields()) {
            field.setAccessible(true);
            Object value = map.get(field.getName());
            if (value == null) continue;
            Class<?> fieldType = field.getType();
            if (fieldType.isAnnotationPresent(NestedConfig.class) && value instanceof LinkedHashMap) {
                LinkedHashMap nestedMap = (LinkedHashMap)value;
                Object nestedInstance = fieldType.getConstructor(new Class[0]).newInstance(new Object[0]);
                ConfigMapper.mapFromMap(nestedMap, nestedInstance);
                field.set(instance, nestedInstance);
                continue;
            }
            if (ConfigMapper.isListType(fieldType) && value instanceof List) {
                List rawList = (List)value;
                List<Object> mappedList = ConfigMapper.convertList(field.getGenericType(), rawList, field.getName());
                field.set(instance, mappedList);
                continue;
            }
            if (ConfigMapper.isMapType(fieldType) && value instanceof LinkedHashMap) {
                LinkedHashMap rawLinkedMap = (LinkedHashMap)value;
                Map<Object, Object> mappedMap = ConfigMapper.convertMap(field.getGenericType(), rawLinkedMap, field.getName());
                field.set(instance, mappedMap);
                continue;
            }
            if (ConfigMapper.isSimpleType(fieldType)) {
                field.set(instance, value);
                continue;
            }
            throw new ConfigMappingException("Cannot map field '" + field.getName() + "' of type " + fieldType.getName() + ". Field must be annotated with @NestedConfig or be a primitive/List/Map/String.");
        }
    }

    private static List<Object> convertList(Type genericType, List<?> rawList, String fieldName) throws Exception {
        ArrayList<Object> mappedList = new ArrayList<Object>();
        if (genericType instanceof ParameterizedType) {
            Class c;
            ParameterizedType parameterizedType = (ParameterizedType)genericType;
            Type listType = parameterizedType.getActualTypeArguments()[0];
            Class listClass = listType instanceof Class ? (c = (Class)listType) : Object.class;
            for (Object item : rawList) {
                if (listClass.isAnnotationPresent(NestedConfig.class)) {
                    Object nestedInstance;
                    if (item instanceof LinkedHashMap) {
                        LinkedHashMap itemMap = (LinkedHashMap)item;
                        nestedInstance = listClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        ConfigMapper.mapFromMap(itemMap, nestedInstance);
                        mappedList.add(nestedInstance);
                        continue;
                    }
                    if (item instanceof ConfigurationSection) {
                        ConfigurationSection itemSection = (ConfigurationSection)item;
                        nestedInstance = listClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                        ConfigMapper.mapSection(itemSection, nestedInstance);
                        mappedList.add(nestedInstance);
                        continue;
                    }
                    throw new ConfigMappingException("Cannot map list item for field '" + fieldName + "': unsupported item type " + (item == null ? "null" : item.getClass().getName()));
                }
                if (ConfigMapper.isSimpleType(listClass)) {
                    mappedList.add(item);
                    continue;
                }
                throw new ConfigMappingException("Cannot map list item of type '" + listClass.getName() + "' in field '" + fieldName + "'. List item type must be annotated with @NestedConfig or be a primitive/String.");
            }
        } else {
            mappedList.addAll(rawList);
        }
        return mappedList;
    }

    private static Map<Object, Object> convertMap(Type genericType, Object rawMap, String fieldName) throws Exception {
        ParameterizedType parameterizedType;
        Type[] typeArgs;
        LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>();
        Class<Object> keyClass = Object.class;
        Class<Object> valueClass = Object.class;
        if (genericType instanceof ParameterizedType && (typeArgs = (parameterizedType = (ParameterizedType)genericType).getActualTypeArguments()).length == 2) {
            Class clazz;
            Class clazz2;
            Type type = typeArgs[0];
            if (type instanceof Class) {
                Class kc = (Class)type;
                clazz2 = (Class)typeArgs[0];
            } else {
                clazz2 = Object.class;
            }
            keyClass = clazz2;
            type = typeArgs[1];
            if (type instanceof Class) {
                Class vc = (Class)type;
                clazz = (Class)typeArgs[1];
            } else {
                clazz = Object.class;
            }
            valueClass = clazz;
        }
        final Class<Object> finalValueClass = valueClass;
        final String finalFieldName = fieldName;
        Function<Object, Object> mapValueMapper = new Function<Object, Object>(){

            @Override
            public Object apply(Object rawValue) {
                try {
                    if (finalValueClass.isAnnotationPresent(NestedConfig.class)) {
                        if (rawValue instanceof LinkedHashMap) {
                            LinkedHashMap itemMap = (LinkedHashMap)rawValue;
                            Object nestedInstance = finalValueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            ConfigMapper.mapFromMap(itemMap, nestedInstance);
                            return nestedInstance;
                        }
                        if (rawValue instanceof ConfigurationSection) {
                            ConfigurationSection itemSection = (ConfigurationSection)rawValue;
                            Object nestedInstance = finalValueClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            ConfigMapper.mapSection(itemSection, nestedInstance);
                            return nestedInstance;
                        }
                        throw new ConfigMappingException("Cannot map map value for field '" + finalFieldName + "': unsupported item type " + (rawValue == null ? "null" : rawValue.getClass().getName()));
                    }
                    if (ConfigMapper.isSimpleType(finalValueClass) || finalValueClass == Object.class) {
                        return rawValue;
                    }
                    throw new ConfigMappingException("Cannot map map value of type '" + finalValueClass.getName() + "' in field '" + finalFieldName + "'. Map value type must be annotated with @NestedConfig or be a primitive/String.");
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RuntimeException(e);
                }
            }
        };
        if (rawMap instanceof ConfigurationSection) {
            ConfigurationSection section = (ConfigurationSection)rawMap;
            for (String key : section.getKeys(false)) {
                Object rawValue = section.get(key);
                Object mappedValue = mapValueMapper.apply(rawValue);
                Object mappedKey = ConfigMapper.convertMapKey(key, keyClass, fieldName);
                result.put(mappedKey, mappedValue);
            }
        } else if (rawMap instanceof Map) {
            Map map = (Map)rawMap;
            for (Map.Entry entry : map.entrySet()) {
                Object rawKey = entry.getKey();
                Object rawValue = entry.getValue();
                Object mappedKey = ConfigMapper.convertMapKey(rawKey, keyClass, fieldName);
                Object mappedValue = mapValueMapper.apply(rawValue);
                result.put(mappedKey, mappedValue);
            }
        } else {
            throw new ConfigMappingException("Field '" + fieldName + "' expected a map-like structure but got " + (rawMap == null ? "null" : rawMap.getClass().getName()));
        }
        return result;
    }

    private static Object convertMapKey(Object rawKey, Class<?> keyClass, String fieldName) throws ConfigMappingException {
        if (keyClass == String.class || keyClass == Object.class) {
            return String.valueOf(rawKey);
        }
        if (keyClass.isAssignableFrom(rawKey.getClass())) {
            return rawKey;
        }
        try {
            String keyStr = String.valueOf(rawKey);
            if (keyClass == Integer.class || keyClass == Integer.TYPE) {
                return Integer.valueOf(keyStr);
            }
            if (keyClass == Long.class || keyClass == Long.TYPE) {
                return Long.valueOf(keyStr);
            }
            if (keyClass == Short.class || keyClass == Short.TYPE) {
                return Short.valueOf(keyStr);
            }
            if (keyClass == Byte.class || keyClass == Byte.TYPE) {
                return Byte.valueOf(keyStr);
            }
            if (keyClass == Double.class || keyClass == Double.TYPE) {
                return Double.valueOf(keyStr);
            }
            if (keyClass == Float.class || keyClass == Float.TYPE) {
                return Float.valueOf(keyStr);
            }
            if (keyClass == Boolean.class || keyClass == Boolean.TYPE) {
                return Boolean.valueOf(keyStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new ConfigMappingException("Cannot convert map key '" + String.valueOf(rawKey) + "' to required key type '" + keyClass.getName() + "' for field '" + fieldName + "'");
    }

    private static boolean isSimpleType(Class<?> type) {
        return type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class;
    }

    private static boolean isListType(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    private static boolean isMapType(Class<?> type) {
        return Map.class.isAssignableFrom(type);
    }
}

