/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.leaderboard;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardEntry;
import java.util.Collections;
import java.util.List;
import org.bukkit.plugin.Plugin;

public final class LeaderBoardService {
    private final CookieClickerZ plugin;
    private volatile List<LeaderBoardEntry> topTotalCookies;
    private volatile List<LeaderBoardEntry> topCpc;

    public LeaderBoardService(CookieClickerZ plugin) {
        this.plugin = plugin;
        this.topTotalCookies = Collections.emptyList();
        this.topCpc = Collections.emptyList();
    }

    public void start() {
        if (!this.plugin.getConfig().getBoolean("leaderboard.enabled", true)) {
            return;
        }
        int refreshInterval = this.plugin.getConfig().getInt("leaderboard.updateInterval", 60);
        this.refreshAsync();
        this.plugin.getServer().getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::refreshSafe, 20L * (long)refreshInterval, 20L * (long)refreshInterval);
    }

    private void refreshAsync() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::refreshSafe);
    }

    private void refreshSafe() {
        try {
            int leaderboardSize = this.plugin.getConfig().getInt("leaderboard.size", 10);
            List<LeaderBoardEntry> newTopTotalCookies = this.plugin.getStorage().getTopCookiesPlayers(leaderboardSize);
            List<LeaderBoardEntry> newTopCpc = this.plugin.getStorage().getTopCpcPlayers(leaderboardSize);
            this.topTotalCookies = newTopTotalCookies;
            this.topCpc = newTopCpc;
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to refresh leaderboard: " + e.getMessage());
        }
    }

    public List<LeaderBoardEntry> getTopTotalCookies() {
        return this.topTotalCookies;
    }

    public List<LeaderBoardEntry> getTopCpc() {
        return this.topCpc;
    }
}

