/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.holograms;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.ClickerManager;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public abstract class HologramManager {
    private final CookieClickerZ plugin;

    public HologramManager(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    protected CookieClickerZ getPlugin() {
        return this.plugin;
    }

    public void spawnAllHolograms() {
        this.getPlugin().getClickerManager().getClickers().forEach(this::spawnHologram);
    }

    public abstract void spawnHologram(@NotNull ClickerManager.Clicker var1);

    public abstract void removeHologram(@NotNull String var1);

    public void removeHologram(@NotNull ClickerManager.Clicker clicker) {
        this.removeHologram(clicker.getName());
    }

    public void removeAllHolograms() {
        this.getPlugin().getClickerManager().getClickers().forEach(this::removeHologram);
    }

    protected String getHologramName(@NotNull ClickerManager.Clicker clicker) {
        return this.getHologramName(clicker.getName());
    }

    protected String getHologramName(@NotNull String clickerName) {
        return "cc_" + clickerName;
    }

    protected Location getHologramLocation(@NotNull ClickerManager.Clicker clicker) {
        double offset = this.getPlugin().getLanguageManager().getDouble("clickerHologramOffset");
        return clicker.getLocation().clone().add(0.5, offset, 0.5);
    }

    protected List<String> getHologramLines(@NotNull ClickerManager.Clicker clicker) {
        return this.getPlugin().getLanguageManager().getStringList("clickerHologram").stream().map(x$0 -> MessageUtils.replacePlaceholders(x$0, new MessageUtils.Replaceable[0])).map(MessageUtils::convertToLegacy).collect(Collectors.toList());
    }
}

