/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.achievements;

import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementCategory;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import java.math.BigInteger;

public class Achievement {
    private final AchievementType type;
    private int progress = 0;

    public Achievement(AchievementType type) {
        this.type = type;
    }

    public Achievement(AchievementType type, int progress) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("Achievement type cannot be null");
        }
        this.type = type;
        this.progress = progress;
    }

    public AchievementType getType() {
        return this.type;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public boolean isCompleted() {
        if (this.type.getCategory() == AchievementCategory.COOKIES) {
            return this.progress == 1;
        }
        return this.progress >= this.type.getIntGoal();
    }

    public int getGoal() {
        return this.type.getIntGoal();
    }

    public BigInteger getBigIntegerGoal() {
        return this.type.getBigIntegerGoal();
    }

    public void printState() {
        System.out.println("---\nAchievement " + String.valueOf((Object)this.getType()) + "\nprogress: " + this.getProgress() + " / " + NumFormatter.formatBigInt(this.getType().getBigIntegerGoal()) + "\ncompleted: " + this.isCompleted() + "\n---");
    }
}

