/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AntiCheat
implements Listener {
    private final JavaPlugin plugin;
    private final HashMap<UUID, ClickData> playerClicks = new HashMap();
    private final HashMap<UUID, Long> lastMove = new HashMap();

    public AntiCheat(JavaPlugin plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        this.startCpsCalculationTask();
    }

    @EventHandler
    public void onPlayerClick(PlayerInteractEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.playerClicks.putIfAbsent(playerId, new ClickData());
        ClickData clickData = this.playerClicks.get(playerId);
        clickData.incrementClicks();
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        UUID playerId = event.getPlayer().getUniqueId();
        this.lastMove.put(playerId, System.currentTimeMillis());
    }

    private void startCpsCalculationTask() {
        new BukkitRunnable(){

            public void run() {
                for (UUID playerId : AntiCheat.this.playerClicks.keySet()) {
                    ClickData clickData = AntiCheat.this.playerClicks.get(playerId);
                    clickData.updateCps();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 20L, 20L);
    }

    public double getCps(UUID playerId) {
        ClickData clickData = this.playerClicks.get(playerId);
        return clickData != null ? clickData.getCps() : 0.0;
    }

    public Long getLastMove(UUID playerId) {
        return this.lastMove.get(playerId);
    }

    private static class ClickData {
        private int clicks = 0;
        private double cps = 0.0;

        private ClickData() {
        }

        public void incrementClicks() {
            ++this.clicks;
        }

        public void updateCps() {
            this.cps = this.clicks;
            this.clicks = 0;
        }

        public double getCps() {
            return this.cps;
        }
    }
}

