/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.listeners.inventory;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.gui.AchievementGUI;
import com.zetaplugins.cookieclickerz.util.gui.GuiAssets;
import com.zetaplugins.cookieclickerz.util.gui.MainGUI;
import com.zetaplugins.cookieclickerz.util.gui.PrestigeGUI;
import com.zetaplugins.cookieclickerz.util.gui.TopGUI;
import com.zetaplugins.cookieclickerz.util.gui.UpgradeGUI;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;

public class MainGuiClickListener
implements Listener {
    private final CookieClickerZ plugin;

    public MainGuiClickListener(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onClickEvent(InventoryClickEvent event) {
        Player player = (Player)event.getWhoClicked();
        if (!MainGUI.isOpen(player)) {
            return;
        }
        switch (event.getSlot()) {
            case 11: {
                if (!player.hasPermission("cookieclickerz.upgrades")) {
                    this.throwPermissionError(player);
                    return;
                }
                GuiAssets.playClickSound(player);
                MainGUI.close(player);
                UpgradeGUI.open(player);
                break;
            }
            case 15: {
                if (!player.hasPermission("cookieclickerz.viewachievements")) {
                    this.throwPermissionError(player);
                    return;
                }
                GuiAssets.playClickSound(player);
                MainGUI.close(player);
                AchievementGUI.open(player);
                break;
            }
            case 29: {
                if (!player.hasPermission("cookieclickerz.prestige")) {
                    this.throwPermissionError(player);
                    return;
                }
                GuiAssets.playClickSound(player);
                MainGUI.close(player);
                PrestigeGUI.open(player);
                break;
            }
            case 33: {
                if (!player.hasPermission("cookieclickerz.top")) {
                    this.throwPermissionError(player);
                    return;
                }
                GuiAssets.playClickSound(player);
                MainGUI.close(player);
                TopGUI.open(player);
            }
        }
        event.setCancelled(true);
    }

    private void throwPermissionError(Player player) {
        Component msg = MessageUtils.getAndFormatMsg(false, "noPermissionError", "&cYou don't have permission to use this!", new MessageUtils.Replaceable[0]);
        player.sendMessage(msg);
    }
}

