/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.commands.MainCommand.subcommands;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.commands.CommandUsageException;
import com.zetaplugins.cookieclickerz.commands.SubCommand;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.RandomGenerators;
import java.math.BigInteger;
import java.util.Objects;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DevSubCommand
implements SubCommand {
    private final CookieClickerZ plugin;

    public DevSubCommand(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(final CommandSender sender, String[] args) throws CommandUsageException {
        if (args.length < 2) {
            throw new CommandUsageException("/cc dev <test | addMockData>");
        }
        String optionTwo = args[1];
        if (optionTwo == null) {
            throw new CommandUsageException("/cc dev <test | addMockData>");
        }
        if (optionTwo.equals("test")) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(true, "devTest", "&7Test successful!", new MessageUtils.Replaceable[0]));
            return true;
        }
        if (optionTwo.equals("addMockData")) {
            if (args.length < 3) {
                throw new CommandUsageException("/cc dev addMockData <amount>");
            }
            String amountString = args[2];
            final int amount = Integer.parseInt(amountString);
            BukkitRunnable runnable = new BukkitRunnable(){

                public void run() {
                    for (int i = 0; i < amount; ++i) {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            player.sendActionBar(MessageUtils.formatMsg("&7Adding mock player &e" + (i + 1) + "/" + amount + "&7...", new MessageUtils.Replaceable[0]));
                        }
                        String name = RandomGenerators.generateRandomWord(8);
                        BigInteger totalCookies = RandomGenerators.generateRandomBigInteger(BigInteger.ZERO, Objects.requireNonNull(NumFormatter.stringToBigInteger("1Q")));
                        int prestige = RandomGenerators.generateRandomNumber(0, 5);
                        PlayerData playerData = new PlayerData(name, DevSubCommand.this.plugin.getServer().getOfflinePlayer(name).getUniqueId());
                        playerData.setTotalCookies(totalCookies);
                        playerData.setPrestige(prestige);
                        playerData.setLastLogoutTime(System.currentTimeMillis() - RandomGenerators.generateRandomLong(0L, 1000000L));
                        playerData.setTotalClicks(RandomGenerators.generateRandomNumber(0, 1000));
                        playerData.setCookiesPerClick(RandomGenerators.generateRandomBigInteger(BigInteger.ONE, Objects.requireNonNull(NumFormatter.stringToBigInteger("100K"))));
                        playerData.setOfflineCookies(RandomGenerators.generateRandomBigInteger(BigInteger.ZERO, Objects.requireNonNull(NumFormatter.stringToBigInteger("100K"))));
                        DevSubCommand.this.plugin.getStorage().save(playerData);
                    }
                    if (sender instanceof Player) {
                        ((Player)sender).playSound(((Player)sender).getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
                    }
                    sender.sendMessage(MessageUtils.formatMsg("&8[&a<b>!<!b>&8] &7Successfully added &e" + amount + " &7mock players!", new MessageUtils.Replaceable[0]));
                }
            };
            runnable.runTaskAsynchronously((Plugin)this.plugin);
            return true;
        }
        if (optionTwo.equals("savecached")) {
            this.plugin.getStorage().saveAllCachedData();
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/cc dev <test | addMockData | savecached>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("cookieclickerz.dev");
    }
}

