/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services;

import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class LocalizationService {
    private final JavaPlugin plugin;
    private final List<String> defaultLangs;
    private final String fallbackLang;
    private final String langFolder;
    private final String langConfigOption;
    private FileConfiguration langConfig;

    public LocalizationService(JavaPlugin plugin, List<String> defaultLangs) {
        this.plugin = plugin;
        this.defaultLangs = defaultLangs;
        this.fallbackLang = "en-US";
        this.langFolder = "lang/";
        this.langConfigOption = "lang";
        this.loadLanguageConfig();
    }

    public LocalizationService(JavaPlugin plugin, List<String> defaultLangs, String fallbackLang, String langFolder, String langConfigOption) {
        this.plugin = plugin;
        this.defaultLangs = defaultLangs;
        this.fallbackLang = fallbackLang;
        this.langFolder = langFolder;
        this.langConfigOption = langConfigOption;
        this.loadLanguageConfig();
    }

    public void reload() {
        this.loadLanguageConfig();
    }

    private void loadLanguageConfig() {
        File languageDirectory = new File(this.plugin.getDataFolder(), this.langFolder);
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            languageDirectory.mkdir();
        }
        for (String langString : this.defaultLangs) {
            File langFile = new File(this.langFolder, langString + ".yml");
            if (new File(languageDirectory, langString + ".yml").exists()) continue;
            this.plugin.getLogger().info("Saving file " + langFile.getPath());
            this.plugin.saveResource(langFile.getPath(), false);
        }
        String langOption = this.plugin.getConfig().getString(this.langConfigOption, this.fallbackLang);
        File selectedLangFile = new File(languageDirectory, langOption + ".yml");
        if (!selectedLangFile.exists()) {
            selectedLangFile = new File(languageDirectory, this.fallbackLang + ".yml");
            this.plugin.getLogger().warning("Language file " + langOption + ".yml (" + selectedLangFile.getPath() + ") not found! Using fallback " + this.fallbackLang + ".yml.");
        }
        this.plugin.getLogger().info("Using language file: " + selectedLangFile.getPath());
        this.langConfig = YamlConfiguration.loadConfiguration((File)selectedLangFile);
    }

    public String getString(String key) {
        return this.langConfig.getString(key);
    }

    public String getString(String key, String fallback) {
        return this.langConfig.getString(key) != null ? this.langConfig.getString(key) : fallback;
    }

    public List<String> getStringList(String key) {
        return this.langConfig.getStringList(key);
    }
}

