/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.holograms;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.util.ClickerManager;
import com.zetaplugins.cookieclickerz.util.holograms.HologramManager;
import de.oliver.fancyholograms.api.FancyHologramsPlugin;
import de.oliver.fancyholograms.api.data.HologramData;
import de.oliver.fancyholograms.api.data.TextHologramData;
import de.oliver.fancyholograms.api.hologram.Hologram;
import org.bukkit.Location;
import org.jetbrains.annotations.NotNull;

public final class FancyHologramManager
extends HologramManager {
    private final de.oliver.fancyholograms.api.HologramManager fancyHologramManager = FancyHologramsPlugin.get().getHologramManager();

    public FancyHologramManager(CookieClickerZ plugin) {
        super(plugin);
    }

    @Override
    public void spawnHologram( @NotNull ClickerManager.Clicker clicker) {
        if (!this.getPlugin().getConfig().getBoolean("hologram")) {
            return;
        }
        if (this.fancyHologramManager.getHologram(this.getHologramName(clicker)).isPresent()) {
            return;
        }
        TextHologramData hologramData = new TextHologramData(this.getHologramName(clicker), this.getHologramLocation(clicker));
        hologramData.setText(this.getHologramLines(clicker));
        Hologram hologram = this.fancyHologramManager.create((HologramData)hologramData);
        this.fancyHologramManager.addHologram(hologram);
    }

    @Override
    public void removeHologram(@NotNull String clickerName) {
        this.fancyHologramManager.getHologram(this.getHologramName(clickerName)).ifPresent(arg_0 -> ((de.oliver.fancyholograms.api.HologramManager)this.fancyHologramManager).removeHologram(arg_0));
    }

    @Override
    protected Location getHologramLocation(@NotNull ClickerManager.Clicker clicker) {
        double offset = this.getPlugin().getLanguageManager().getDouble("clickerHologramOffset");
        return clicker.getLocation().clone().add(0.5, offset - 0.5, 0.5);
    }
}

