/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util.cookieevents;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.MessageUtils;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.achievements.AchievementType;
import java.math.BigDecimal;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public enum CookieEventType {
    COOKIE_FRENZY(0.005, 77L, true){

        @Override
        public void run(CookieClickerZ plugin, UUID uuid) {
            PlayerData playerData = plugin.getStorage().load(uuid);
            if (playerData == null) {
                return;
            }
            playerData.progressAchievement(AchievementType.SUGAR_RUSH, 1, plugin);
            playerData.progressAchievement(AchievementType.EVENT_HORIZON, 1, plugin);
            plugin.getStorage().save(playerData);
        }
    }
    ,
    LUCKY(0.007, 0L, true){

        @Override
        public void run(CookieClickerZ plugin, UUID uuid) {
            Player player = plugin.getServer().getPlayer(uuid);
            if (player == null) {
                return;
            }
            PlayerData playerData = plugin.getStorage().load(uuid);
            if (playerData == null) {
                return;
            }
            BigDecimal totalCookies = new BigDecimal(playerData.getTotalCookies());
            BigDecimal luckyAmount = totalCookies.multiply(new BigDecimal("0.1"));
            playerData.setTotalCookies(playerData.getTotalCookies().add(luckyAmount.toBigInteger()));
            playerData.progressAchievement(AchievementType.EVENT_HORIZON, 1, plugin);
            if (luckyAmount.compareTo(new BigDecimal("1000000")) > 0) {
                playerData.progressAchievement(AchievementType.MONEY_MAGNET, 1, plugin);
            }
            plugin.getStorage().save(playerData);
            player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.0f);
            player.sendMessage(MessageUtils.getAndFormatMsg(true, "eventMessages.instant.LUCKY", "%ac%&lLucky! &r&7You got %ac%%amount% &7cookies!", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(luckyAmount.toBigInteger()))));
        }
    }
    ,
    CLICK_FRENZY(0.002, 7L, true){

        @Override
        public void run(CookieClickerZ plugin, UUID uuid) {
            PlayerData playerData = plugin.getStorage().load(uuid);
            if (playerData == null) {
                return;
            }
            playerData.progressAchievement(AchievementType.EVENT_HORIZON, 1, plugin);
            plugin.getStorage().save(playerData);
        }
    }
    ,
    RUIN(0.002, 0L, false){

        @Override
        public void run(CookieClickerZ plugin, UUID uuid) {
            Player player = plugin.getServer().getPlayer(uuid);
            if (player == null) {
                return;
            }
            PlayerData playerData = plugin.getStorage().load(uuid);
            if (playerData == null) {
                return;
            }
            BigDecimal totalCookies = new BigDecimal(playerData.getTotalCookies());
            BigDecimal ruinAmount = totalCookies.multiply(new BigDecimal("0.05"));
            playerData.setTotalCookies(playerData.getTotalCookies().subtract(ruinAmount.toBigInteger()));
            playerData.progressAchievement(AchievementType.EVENT_HORIZON, 1, plugin);
            playerData.progressAchievement(AchievementType.NOT_MY_COOKIES, 1, plugin);
            if (ruinAmount.compareTo(new BigDecimal("1000000")) > 0) {
                playerData.progressAchievement(AchievementType.OOF, 1, plugin);
            }
            plugin.getStorage().save(playerData);
            player.playSound(player.getLocation(), Sound.ENTITY_ELDER_GUARDIAN_CURSE, 1.0f, 1.0f);
            player.sendMessage(MessageUtils.getAndFormatMsg(true, "eventMessages.instant.RUIN", "&c&lRuin! &r&7You lost %ac%%amount% &7cookies!", new MessageUtils.Replaceable<String>("%amount%", NumFormatter.formatBigInt(ruinAmount.toBigInteger()))));
        }
    }
    ,
    CURSED_FINGER(0.002, 66L, false){

        @Override
        public void run(CookieClickerZ plugin, UUID uuid) {
            PlayerData playerData = plugin.getStorage().load(uuid);
            if (playerData == null) {
                return;
            }
            playerData.progressAchievement(AchievementType.EVENT_HORIZON, 1, plugin);
            playerData.progressAchievement(AchievementType.NOT_MY_COOKIES, 1, plugin);
            plugin.getStorage().save(playerData);
        }
    };

    private final String id = this.name();
    private final double appearanceRate;
    private final long duration;
    private final boolean isPositive;
    private static final Random random;

    private CookieEventType(double appearanceRate, long duration, boolean isPositive) {
        this.appearanceRate = appearanceRate;
        this.duration = duration * 20L;
        this.isPositive = isPositive;
    }

    public String getId() {
        return this.id;
    }

    public boolean isPositive() {
        return this.isPositive;
    }

    public double getAppearanceRate() {
        return CookieClickerZ.getInstance().getConfig().getDouble("events.rates." + this.name(), this.appearanceRate);
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean isInstant() {
        return this.duration == 0L;
    }

    public abstract void run(CookieClickerZ var1, UUID var2);

    @Nullable
    public static CookieEventType getRandom() {
        double totalRate = 0.0;
        for (CookieEventType eventType : CookieEventType.values()) {
            totalRate += eventType.getAppearanceRate();
        }
        double noEventRate = 1.0 - totalRate;
        if (noEventRate < 0.0) {
            throw new IllegalStateException("The sum of appearance rates is greater than 1");
        }
        double randomValue = random.nextDouble() * (totalRate += noEventRate);
        double cumulativeRate = 0.0;
        for (CookieEventType eventType : CookieEventType.values()) {
            if (!(randomValue <= (cumulativeRate += eventType.getAppearanceRate()))) continue;
            return eventType;
        }
        return null;
    }

    static {
        random = new Random();
    }
}

