/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.util;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardEntry;
import java.util.List;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;

public class PapiExpansion
extends PlaceholderExpansion {
    private final CookieClickerZ plugin;

    public PapiExpansion(CookieClickerZ plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "Kartoffelchipss";
    }

    @NotNull
    public String getIdentifier() {
        return "cookieclickerz";
    }

    @NotNull
    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, @NotNull String identifier) {
        int index;
        String[] parts;
        if (player == null || player.getPlayer() == null) {
            return "PlayerNotFound";
        }
        switch (identifier) {
            case "name": {
                return player.getName();
            }
            case "totalcookies": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return playerData.getTotalCookies().toString();
            }
            case "totalcookies_formatted": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return NumFormatter.formatBigInt(playerData.getTotalCookies());
            }
            case "cookiesperclick": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return NumFormatter.formatBigInt(playerData.getCookiesPerClick());
            }
            case "offlinecookies": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return NumFormatter.formatBigInt(playerData.getOfflineCookies());
            }
            case "prestige": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf(playerData.getPrestige());
            }
            case "totalclicks": {
                PlayerData playerData = this.plugin.getStorage().load(player.getUniqueId());
                return String.valueOf(playerData.getTotalClicks());
            }
        }
        if (identifier.startsWith("cookies_top_")) {
            parts = identifier.split("_");
            if (parts.length >= 4) {
                try {
                    index = Integer.parseInt(parts[2]);
                    String field = parts[3].toLowerCase();
                    List<LeaderBoardEntry> top = this.plugin.getLeaderBoardService().getTopTotalCookies();
                    if (index <= 0 || index > top.size()) {
                        return "N/A";
                    }
                    LeaderBoardEntry e = top.get(index - 1);
                    switch (field) {
                        case "name": {
                            return e.name;
                        }
                        case "amount": {
                            return e.totalCookies.toString();
                        }
                        case "formattedamount": {
                            return NumFormatter.formatBigInt(e.totalCookies);
                        }
                    }
                    return "InvalidField";
                }
                catch (NumberFormatException ignored) {
                    return "InvalidIndex";
                }
            }
            return "InvalidPlaceholder";
        }
        if (identifier.startsWith("cpc_top_")) {
            parts = identifier.split("_");
            if (parts.length >= 4) {
                try {
                    index = Integer.parseInt(parts[2]);
                    String field = parts[3].toLowerCase();
                    List<LeaderBoardEntry> top = this.plugin.getLeaderBoardService().getTopCpc();
                    if (index <= 0 || index > top.size()) {
                        return "N/A";
                    }
                    LeaderBoardEntry e = top.get(index - 1);
                    switch (field) {
                        case "name": {
                            return e.name;
                        }
                        case "amount": {
                            return e.cookiesPerClick.toString();
                        }
                        case "formattedamount": {
                            return NumFormatter.formatBigInt(e.cookiesPerClick);
                        }
                    }
                    return "InvalidField";
                }
                catch (NumberFormatException ignored) {
                    return "InvalidIndex";
                }
            }
            return "InvalidPlaceholder";
        }
        return "InvalidPlaceholder";
    }
}

