/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.cookieclickerz.storage;

import com.zetaplugins.cookieclickerz.CookieClickerZ;
import com.zetaplugins.cookieclickerz.storage.PlayerData;
import com.zetaplugins.cookieclickerz.storage.SQLStorage;
import com.zetaplugins.cookieclickerz.util.NumFormatter;
import com.zetaplugins.cookieclickerz.util.achievements.Achievement;
import com.zetaplugins.cookieclickerz.util.leaderboard.LeaderBoardEntry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public final class SQLiteStorage
extends SQLStorage {
    private final Map<UUID, PlayerData> playerDataCache = new ConcurrentHashMap<UUID, PlayerData>();
    private static final String CSV_SEPARATOR = ",";

    public SQLiteStorage(CookieClickerZ plugin) {
        super(plugin);
    }

    @Override
    public void init() {
        try (Connection connection = this.createConnection();){
            Statement statement;
            if (connection == null) {
                return;
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS players (uuid TEXT PRIMARY KEY, name TEXT, totalCookies TEXT, totalClicks INTEGER, lastLogoutTime INTEGER, cookiesPerClick TEXT, offlineCookies TEXT,prestige INTEGER DEFAULT 0)");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create players table in SQLite database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS upgrades (uuid TEXT, upgrade_name TEXT, level INTEGER, PRIMARY KEY (uuid, upgrade_name), FOREIGN KEY (uuid) REFERENCES players(uuid))");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create upgrades table in SQLite database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE TABLE IF NOT EXISTS achievements (uuid TEXT, achievement_name TEXT, progress INTEGER, PRIMARY KEY (uuid, achievement_name), FOREIGN KEY (uuid) REFERENCES players(uuid))");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to create achievements table in SQLite database: " + e.getMessage());
            }
            try {
                statement = connection.createStatement();
                try {
                    statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_players_cookie_order ON players (LENGTH(totalCookies) DESC, totalCookies DESC);");
                    statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_players_cpc_order ON players (LENGTH(cookiesPerClick) DESC, cookiesPerClick DESC);");
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to enable foreign key support in SQLite database: " + e.getMessage());
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to initialize SQLite database: " + e.getMessage());
        }
    }

    @Override
    Connection createConnection() {
        try {
            CookieClickerZ plugin = this.getPlugin();
            String pluginFolderPath = plugin.getDataFolder().getPath();
            return DriverManager.getConnection("jdbc:sqlite:" + pluginFolderPath + "/userData.db");
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to create connection to SQLite database: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void save(PlayerData playerData) {
        if (playerData == null) {
            return;
        }
        if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(playerData.getUuid())) {
            this.playerDataCache.put(playerData.getUuid(), playerData);
            return;
        }
        String query = "INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, playerData.getName());
                statement.setString(3, playerData.getTotalCookies().toString());
                statement.setInt(4, playerData.getTotalClicks());
                statement.setLong(5, playerData.getLastLogoutTime());
                statement.setString(6, playerData.getCookiesPerClick().toString());
                statement.setString(7, playerData.getOfflineCookies().toString());
                statement.setInt(8, playerData.getPrestige());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to save player data to SQLite database: " + e.getMessage());
            }
            this.saveUpgrades(connection, playerData);
            this.saveAchievements(connection, playerData);
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save player data to SQLite database: " + e.getMessage());
        }
    }

    private void saveUpgrades(Connection connection, PlayerData playerData) throws SQLException {
        if (playerData.hasRemovedUpgrades()) {
            String deleteQuery = "DELETE FROM upgrades WHERE uuid = ?";
            try (PreparedStatement deleteStatement = connection.prepareStatement("DELETE FROM upgrades WHERE uuid = ?");){
                deleteStatement.setString(1, playerData.getUuid().toString());
                deleteStatement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to delete upgrades for player: " + e.getMessage());
                throw e;
            }
        }
        String query = "INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON CONFLICT(uuid, upgrade_name) DO UPDATE SET level = excluded.level";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO upgrades (uuid, upgrade_name, level) VALUES (?, ?, ?) ON CONFLICT(uuid, upgrade_name) DO UPDATE SET level = excluded.level");){
            for (Map.Entry<String, Integer> entry : playerData.getUpgrades().entrySet()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, entry.getKey());
                statement.setInt(3, entry.getValue());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save upgrades for player: " + e.getMessage());
            throw e;
        }
    }

    private void saveAchievements(Connection connection, PlayerData playerData) throws SQLException {
        String query = "INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress";
        try (PreparedStatement statement = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress");){
            for (Achievement achievement : playerData.getAchievements()) {
                statement.setString(1, playerData.getUuid().toString());
                statement.setString(2, achievement.getType().getSlug());
                statement.setInt(3, achievement.getProgress());
                statement.addBatch();
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to save achievements for player: " + e.getMessage());
            throw e;
        }
    }

    @Override
    public PlayerData load(UUID uuid) {
        PlayerData playerData;
        block12: {
            if (this.shouldUsePlayerCache() && this.playerDataCache.containsKey(uuid)) {
                return this.playerDataCache.get(uuid);
            }
            Connection connection = this.createConnection();
            try {
                PlayerData playerData2 = this.loadPlayerData(connection, uuid);
                if (playerData2 != null) {
                    this.loadUpgrades(connection, uuid, playerData2);
                    this.loadAchievements(connection, uuid, playerData2);
                    if (this.shouldUsePlayerCache()) {
                        this.playerDataCache.put(uuid, playerData2);
                        if (this.playerDataCache.size() > this.getMaxCacheSize()) {
                            this.saveAllCachedData();
                        }
                    }
                }
                playerData = playerData2;
                if (connection == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().severe("Failed to load player data from SQLite database: " + e.getMessage());
                    return null;
                }
            }
            connection.close();
        }
        return playerData;
    }

    @Override
    public PlayerData load(String uuid) {
        return this.load(UUID.fromString(uuid));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void importData(String fileName) {
        String filePath = this.getPlugin().getDataFolder().getPath() + "/" + fileName;
        try (BufferedReader reader = new BufferedReader(new FileReader(filePath));){
            String line;
            while ((line = reader.readLine()) != null) {
                String[] data = line.split(CSV_SEPARATOR);
                if (data.length != 8) {
                    this.getPlugin().getLogger().severe("Invalid CSV format.");
                    continue;
                }
                try {
                    Connection connection;
                    block26: {
                        connection = this.createConnection();
                        if (connection != null) break block26;
                        if (connection == null) return;
                        connection.close();
                        return;
                    }
                    try {
                        try {
                            PreparedStatement statement = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                            try {
                                statement.setString(1, data[0]);
                                statement.setString(2, data[1]);
                                statement.setString(3, data[2]);
                                statement.setInt(4, Integer.parseInt(data[3]));
                                statement.setLong(5, Long.parseLong(data[4]));
                                statement.setString(6, data[5]);
                                statement.setString(7, data[6]);
                                statement.setInt(8, Integer.parseInt(data[7]));
                                statement.executeUpdate();
                            }
                            finally {
                                if (statement == null) continue;
                                statement.close();
                            }
                        }
                        catch (SQLException e) {
                            this.getPlugin().getLogger().severe("Failed to import player data from CSV file: " + e.getMessage());
                        }
                    }
                    finally {
                        if (connection == null) continue;
                        connection.close();
                    }
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().severe("Failed to import player data from CSV file: " + e.getMessage());
                }
            }
            return;
        }
        catch (IOException e) {
            this.getPlugin().getLogger().severe("Failed to read CSV file: " + e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LeaderBoardEntry> getTopCookiesPlayers(int limit) {
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                List<LeaderBoardEntry> list = List.of();
                return list;
            }
            ArrayList<LeaderBoardEntry> topPlayers = new ArrayList<LeaderBoardEntry>();
            String query = "SELECT ROW_NUMBER() OVER (ORDER BY LENGTH(totalCookies) DESC, totalCookies DESC) AS rank, uuid, name, totalCookies, cookiesPerClick FROM players ORDER BY LENGTH(totalCookies) DESC, totalCookies DESC LIMIT ?";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, limit);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        UUID uuid = UUID.fromString(rs.getString("uuid"));
                        String name = rs.getString("name");
                        BigInteger totalCookies = NumFormatter.stringToBigInteger(rs.getString("totalCookies"));
                        BigInteger cpc = NumFormatter.stringToBigInteger(rs.getString("cookiesPerClick"));
                        topPlayers.add(new LeaderBoardEntry(uuid, name, totalCookies, cpc));
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to retrieve top players by total cookies from SQLite database: " + e.getMessage());
            }
            ArrayList<LeaderBoardEntry> arrayList = topPlayers;
            return arrayList;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to retrieve top players by total cookies from SQLite database: " + e.getMessage());
            return List.of();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<LeaderBoardEntry> getTopCpcPlayers(int limit) {
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                List<LeaderBoardEntry> list = List.of();
                return list;
            }
            ArrayList<LeaderBoardEntry> topPlayers = new ArrayList<LeaderBoardEntry>();
            String query = "SELECT ROW_NUMBER() OVER (ORDER BY LENGTH(totalCookies) DESC, totalCookies DESC) AS rank, uuid, name, totalCookies, cookiesPerClick FROM players ORDER BY LENGTH(cookiesPerClick) DESC, cookiesPerClick DESC LIMIT ?";
            try (PreparedStatement statement = connection.prepareStatement(query);){
                statement.setInt(1, limit);
                try (ResultSet rs = statement.executeQuery();){
                    while (rs.next()) {
                        UUID uuid = UUID.fromString(rs.getString("uuid"));
                        String name = rs.getString("name");
                        BigInteger totalCookies = NumFormatter.stringToBigInteger(rs.getString("totalCookies"));
                        BigInteger cpc = NumFormatter.stringToBigInteger(rs.getString("cookiesPerClick"));
                        topPlayers.add(new LeaderBoardEntry(uuid, name, totalCookies, cpc));
                    }
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().severe("Failed to retrieve top players by cpc from SQLite database: " + e.getMessage());
            }
            ArrayList<LeaderBoardEntry> arrayList = topPlayers;
            return arrayList;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to retrieve top players by cpc from SQLite database: " + e.getMessage());
            return List.of();
        }
    }

    @Override
    public void saveAllCachedData() {
        if (this.playerDataCache.isEmpty()) {
            return;
        }
        HashMap<UUID, PlayerData> snapshot = new HashMap<UUID, PlayerData>(this.playerDataCache);
        try (Connection connection = this.createConnection();){
            if (connection == null) {
                return;
            }
            connection.setAutoCommit(false);
            try (PreparedStatement psPlayers = connection.prepareStatement("INSERT OR REPLACE INTO players (uuid, name, totalCookies, totalClicks, lastLogoutTime, cookiesPerClick, offlineCookies, prestige) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");){
                for (PlayerData data : snapshot.values()) {
                    psPlayers.setString(1, data.getUuid().toString());
                    psPlayers.setString(2, data.getName());
                    psPlayers.setString(3, data.getTotalCookies().toString());
                    psPlayers.setInt(4, data.getTotalClicks());
                    psPlayers.setLong(5, data.getLastLogoutTime());
                    psPlayers.setString(6, data.getCookiesPerClick().toString());
                    psPlayers.setString(7, data.getOfflineCookies().toString());
                    psPlayers.setInt(8, data.getPrestige());
                    psPlayers.addBatch();
                }
                psPlayers.executeBatch();
            }
            for (PlayerData data : snapshot.values()) {
                try {
                    this.saveUpgrades(connection, data);
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.WARNING, "Failed to save upgrades for player " + String.valueOf(data.getUuid()) + ": " + e.getMessage(), e);
                }
            }
            try (PreparedStatement psAchievements = connection.prepareStatement("INSERT INTO achievements (uuid, achievement_name, progress) VALUES (?, ?, ?) ON CONFLICT(uuid, achievement_name) DO UPDATE SET progress = excluded.progress");){
                for (PlayerData data : snapshot.values()) {
                    for (Achievement achievement : data.getAchievements()) {
                        psAchievements.setString(1, data.getUuid().toString());
                        psAchievements.setString(2, achievement.getType().getSlug());
                        psAchievements.setInt(3, achievement.getProgress());
                        psAchievements.addBatch();
                    }
                }
                psAchievements.executeBatch();
            }
            connection.commit();
            this.playerDataCache.keySet().removeAll(snapshot.keySet());
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().severe("Failed to flush player data cache: " + e.getMessage());
        }
    }
}

